% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rss.sign.test.R
\name{rss.sign.test}
\alias{rss.sign.test}
\title{RSS Sign test}
\usage{
rss.sign.test(data, alpha = 0.05, alternative = "two.sided", median0)
}
\arguments{
\item{data}{A numeric data frame of ranked set samples with columns \code{rank} for ranks and \code{y} for data values.}

\item{alpha}{A numeric value specifying the confidence level for the interval.}

\item{alternative}{A character string specifying the alternative hypothesis. Must be one of "two.sided" (default), "greater", or "less".}

\item{median0}{A numeric value indicating the hypothesized median for the one-sample test.}
}
\value{
\item{RSS_median}{The RSS median estimate.}
\item{sign}{The sign-statistic for the test.}
\item{CI}{The confidence interval for the population median.}
\item{z}{The z-statistic for the test.}
\item{p.value}{The p-value for the test.}
}
\description{
The rss.sign.test function performs Sign test on ranked set sample data, supporting both balanced and unbalanced RSS designs.
}
\details{
This function performs a one-sample sign test on ranked set samples. For balanced RSS (BRSS), it uses the method introduced by Hettmansperger (1995), while for unbalanced RSS (URSS), it follows the approach described by Barabesi (2001). Provide \code{data} as a data frame with columns \code{rank} and \code{y}. The function calculates the sign statistic, confidence intervals, and p-value based on the RSS data.
}
\examples{
## Unbalanced RSS with a set size 3 and different sample sizes of 12, 9, 6 for each stratum,
## using imperfect ranking from a lognormal distribution with a mean of 0.
rss.data=rss.simulation(H=3,nsamp=c(12,9,6),dist="lognorm", rho=0.8,delta=0)

## RSS sign-test
rss.sign.test(data=rss.data, alpha=0.05, alternative="two.sided", median0=0)

}
\references{
T. P. Hettmansperger. (1995) The ranked-set sample sign test. Journal of Non-parametric Statistics, 4:263–270.

L. Barabesi. (2001) The unbalanced ranked-set sample sign test. Journal of Non-parametric Statistics, 13(2):279–289.

Chen, Z., Bai Z., Sinha B. K. (2003). Ranked Set Sampling: Theory and Application. New York: Springer.

S. Ahn, X. Wang, C. Moon, and J. Lim. (2024) New scheme of empirical likelihood method for ranked set sampling: Applications to two one sample problems. Internation Statistical Review.
}
\seealso{
\code{\link{rss.simulation}}: used for simulating Ranked Set Samples (RSS), which can serve as input.

\code{\link{rss.sampling}}: used for sampling Ranked Set Samples (RSS) from a population data set, providing input data.
}
