% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/annotations.R
\name{get_annotation}
\alias{get_annotation}
\title{Retrieve metadata for an annotation}
\usage{
get_annotation(annotation_id, access_token = genius_token())
}
\arguments{
\item{annotation_id}{ID of the annotation}

\item{access_token}{Genius' client access token, defaults to \code{genius_token}}
}
\value{
a \code{genius_annotation} object that contains the extracted content from the request,
the original JSON response object and the request path.
}
\description{
The Genius API lets you return data for a specific annotation, given an
annotation ID. \code{get_annotation} returns this data in full.
}
\details{
A Genius annotation is a piece of content about a part of a document.
The document may be a song (hosted on Genius) or a web page (hosted anywhere).
The part of a document that an annotation is attached to is called a referent.
}
\examples{
\dontrun{
get_annotation(annotation_id = 16511101)
}
}
\seealso{
Other annotation: 
\code{\link{get_referent}()}
}
\concept{annotation}
