% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/georefar.R
\name{get_departamentos}
\alias{get_departamentos}
\title{Obtener Departamentos}
\usage{
get_departamentos(
  id = NULL,
  nombre = NULL,
  provincia = NULL,
  orden = NULL,
  aplanar = TRUE,
  campos = NULL,
  max = NULL,
  exacto = NULL
)
}
\arguments{
\item{id}{text Filtrar por ID.}

\item{nombre}{text Filtrar por Nombre.}

\item{provincia}{text Filtrar por nombre o ID de Provincia.}

\item{orden}{text Campo por el cual ordenar los resultados.  (Por ID o nombre)}

\item{aplanar}{boolean Cuando está presente, muestra el resultado JSON con una estructura plana.}

\item{campos}{text Campos a incluir en la respuesta separados por comas, sin espacios. Algunos campos siempre serán incluidos, incluso si no se agregaron en la lista. Para incluir campos de sub-entidades, separar los nombres con un punto, por ejemplo: provincia.id.}

\item{max}{integer Cantidad máxima de resultados a devolver.}

\item{exacto}{boolean Cuando está presente, se activa el modo de búsqueda por texto exacto. Sólo tiene efecto cuando se usan campos de búsqueda por texto (por ejemplo, nombre).}
}
\value{
Un Data Frame con el listado de Departamentos
}
\description{
Permite realizar búsquedas sobre el listado de departamentos.
Realiza la consulta GET al endpoint /departamentos de georef-ar-api.
Si existe GEOREFAR_TOKEN en el Renviron lo usará para hacer la consulta.
}
\examples{
\dontrun{
get_departamentos()
}
}
\references{
\href{https://datosgobar.github.io/georef-ar-api/open-api/#/Recursos/get_departamentos}{georef-ar-api/departamentos}
}
