% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/uncertainty.R
\name{undecidedUnits}
\alias{undecidedUnits}
\title{Undecided observations}
\usage{
undecidedUnits(belongmatrix, tol = 0.1, out = "character")
}
\arguments{
\item{belongmatrix}{The membership matrix obtained at the end of the algorithm}

\item{tol}{A float indicating the minimum required level of membership to be
not considered as undecided}

\item{out}{The format of the output vector. Default is "character". If
"numeric", then the undecided units are set to -1.}
}
\value{
A vector indicating the most likely group for each observation or
  "Undecided" if the maximum probability for the observation does not reach
  the value of the tol parameter
}
\description{
Identify the observation for which the classification is uncertain
}
\examples{
data(LyonIris)
AnalysisFields <-c("Lden","NO2","PM25","VegHautPrt","Pct0_14","Pct_65","Pct_Img",
"TxChom1564","Pct_brevet","NivVieMed")
dataset <- sf::st_drop_geometry(LyonIris[AnalysisFields])
queen <- spdep::poly2nb(LyonIris,queen=TRUE)
Wqueen <- spdep::nb2listw(queen,style="W")
result <- SFCMeans(dataset, Wqueen,k = 5, m = 1.5, alpha = 1.5, standardize = TRUE)
undecidedUnits(result$Belongings, tol = 0.45)
}
