% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multistar_relate_dimension.R
\name{relate_dimension}
\alias{relate_dimension}
\alias{relate_dimension.multistar}
\title{Relate a dimension table to a fact table in a \code{multistar}}
\usage{
relate_dimension(ms, dimension_name = NULL, fact_name = NULL, fact_key = NULL)

\method{relate_dimension}{multistar}(ms, dimension_name = NULL, fact_name = NULL, fact_key = NULL)
}
\arguments{
\item{ms}{A \code{multistar} object.}

\item{dimension_name}{A string, name of dimension table.}

\item{fact_name}{A string, name of fact table.}

\item{fact_key}{A string, name of the dimension foreign key.}
}
\value{
A \code{multistar}.
}
\description{
Adding a dimension to a \code{multistar} can only relate to a fact table. You can
then relate to other fact tables in the \code{multistar} using this function. The
name of the fact table and its foreign key must be indicated. The referential
integrity of the instances of the facts is checked.
}
\examples{

ms <- multistar() |>
  add_facts(
    fact_name = "mrs_age",
    fact_table = mrs_fact_age,
    measures = "n_deaths",
    nrow_agg = "count"
  ) |>
  add_facts(
    fact_name = "mrs_cause",
    fact_table = mrs_fact_cause,
    measures = c("pneumonia_and_influenza_deaths", "other_deaths"),
    nrow_agg = "nrow_agg"
  ) |>
  add_dimension(
    dimension_name = "where",
    dimension_table = mrs_where,
    dimension_key = "where_pk",
    fact_name = "mrs_age",
    fact_key = "where_fk"
  ) |>
  add_dimension(
    dimension_name = "when",
    dimension_table = mrs_when,
    dimension_key = "when_pk",
    fact_name = "mrs_age",
    fact_key = "when_fk",
    key_as_data = TRUE
  ) |>
  add_dimension(
    dimension_name = "who",
    dimension_table = mrs_who,
    dimension_key = "who_pk",
    fact_name = "mrs_age",
    fact_key = "who_fk"
  ) |>
  relate_dimension(dimension_name = "where",
                   fact_name = "mrs_cause",
                   fact_key = "where_fk") |>
  relate_dimension(dimension_name = "when",
                   fact_name = "mrs_cause",
                   fact_key = "when_fk")

}
\seealso{
Other multistar functions: 
\code{\link{add_dimension}()},
\code{\link{add_facts}()},
\code{\link{multistar}()}
}
\concept{multistar functions}
