% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Taylor_McLennan__1995.R
\docType{data}
\name{CC_Bulk__Taylor_McLennan__1995}
\alias{CC_Bulk__Taylor_McLennan__1995}
\title{Bulk Continental Crust}
\format{
A data frame with 1 row and 63 element concentrations in ppm. These elements are:\cr
Li, Be, B, Na, Mg, Al, Si, K, Ca, Sc, Ti, V, Cr, Mn, Fe, Co, Ni, Cu, Zn, Ga, Ge, As, Se, Rb, Sr, Y, Zr, Nb, Mo, Pd, Ag, Cd, In, Sn, Sb, Cs, Ba, La, Ce, Pr, Nd, Sm, Eu, Gd, Tb, Dy, Ho, Er, Tm, Yb, Lu, Hf, Ta, W, Re, Os, Ir, Au, Tl, Pb, Bi, Th, U
}
\usage{
CC_Bulk__Taylor_McLennan__1995
}
\description{
A data set containing the composition of the \emph{Bulk Continental Crust} as given by \insertCite{taylor1995geochemical;textual}{georefdatar}
}
\details{
In this work the concentrations of most elements are given in ppm and
some concentrations are given in wt\% or ppb.\cr
For the sake of unity the values given in either wt\% or ppb where converted
to ppm. So all listed values are in ppm.\cr
This conversion was done using:
\itemize{
\item \verb{ppm= wt\% * 10000}
\item \code{ppm= ppb / 1000}
}
}
\references{
{
\insertRef{taylor1995geochemical}{georefdatar}
}
}
\keyword{datasets}
