% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gboot_cross.R
\name{gboot_cross}
\alias{gboot_cross}
\title{Cross-validation bootstrap}
\usage{
gboot_cross(data,var,model,B)
}
\arguments{
\item{data}{object of the class geodata.}

\item{var}{object of the class variogram.}

\item{model}{object of the class variomodel.}

\item{B}{number of the bootstrap that will be performed (default B=1000).}
}
\value{
\bold{variogram_boot} gives the variogram of each bootstrap.

\bold{variogram_or} gives the original variogram.

\bold{pars_boot} gives the estimatives of the nugget, sill, contribution, range and practical range for each bootstrap.

\bold{pars_or} gives the original estimatives of the nugget, sill, contribution, range and practical range.

Invalid arguments will return an error message.
}
\description{
Performs a boostrap based on error from the cross-validation
}
\details{
We can define the error of prediction by \eqn{\epsilon({s_i})=Z({s_i})-\hat Z({s_i})},
where \eqn{\hat Z({s_i})} are obtained from cross-validation. The steps of the algorithm are:

\enumerate{
\item Set \eqn{{s_i}^*={s_i}};
\item Obtain \eqn{\hat Z({s_i})} from \eqn{\hat Z({s_i})=\sum\limits_{j \ne i}^{n - 1}{{\lambda _j}Z({s_j})}};
\item Calculate \eqn{\epsilon({s_i})=Z({s_i})-\hat Z({s_i})}
\item Sample with replacement \eqn{\epsilon^*(s_i)} from \eqn{\epsilon (s_i) - \bar \epsilon (s_i)};
\item The new data will be \eqn{Z^*({s_i})=\hat Z({s_i})+ \epsilon^*(s_i)};
\item Calculate the new variogram;
\item Calculate and save the statistics of interest;
\item Return to step 4 and repeat the process at least 1000 times.
}
}
\examples{

\donttest{
# Example 1

## transforming the data.frame in an object of class geodata
data<- as.geodata(soilmoisture)

points(data) ## data visualization

var<- variog(data, max.dist = 140) ## Obtaining the variogram
plot(var)

## Fitting the model
mod<- variofit(var,ini.cov.pars = c(2,80),nugget = 2,cov.model = "sph")
lines(mod, col=2, lwd=2) ##fitted model

## Bootstrap procedure

boot<- gboot_cross(data,var,mod,B=10)
## For better Confidence interval, try B=1000

gboot_CI(boot,digits = 4) ## Bootstrap Confidence Interval

gboot_plot(boot) ## Bootstrap Variogram plot

# Example 2

## transforming the data.frame in an object of class geodata
data<- as.geodata(NVDI)

points(data) ## data visualization

var<- variog(data, max.dist = 18) ## Obtaining the variogram
plot(var)

## Fitting the model
mod<- variofit(var,ini.cov.pars = c(0.003,6),nugget = 0.003,cov.model = "gaus")
lines(mod, col=2, lwd=2) ##fitted model

## Bootstrap procedure

boot<- gboot_cross(data,var,mod,B=10)
## For better Confidence interval, try B=1000

gboot_CI(boot,digits = 4) ## Bootstrap Confidence Interval

gboot_plot(boot) ## Bootstrap Variogram plot
}

}
\author{
Diogo Francisco Rossoni \email{dfrossoni@uem.br}

Vinicius Basseto Felix \email{felix_prot@hotmail.com}
}
\keyword{Bootstrap}
\keyword{Cross-validation}
\keyword{Spatial}
