% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparisons.R
\name{get_plot_info}
\alias{get_plot_info}
\title{Get Plotting Information}
\usage{
get_plot_info(
  outcome_name,
  compevent_name,
  compevent2_name,
  censor_name,
  time_name,
  id,
  time_points,
  covnames,
  covtypes,
  nat_pool,
  nat_result,
  comprisk,
  comprisk2,
  censor,
  fitD2,
  fitC,
  outcome_type,
  obs_data,
  ipw_cutoff_quantile,
  ipw_cutoff_value
)
}
\arguments{
\item{outcome_name}{Character string specifying the name of the outcome variable in \code{obs_data}.}

\item{compevent_name}{Character string specifying the name of the competing event variable in \code{obs_data}.}

\item{compevent2_name}{Character string specifying the name of the competing event variable in \code{obs_data} if competing events are treated as censoring events.}

\item{censor_name}{Character string specifying the name of the censoring variable in \code{obs_data}.}

\item{time_name}{Character string specifying the name of the time variable in \code{obs_data}.}

\item{id}{Character string specifying the name of the ID variable in \code{obs_data}.}

\item{time_points}{Number of time points to simulate.}

\item{covnames}{Vector of character strings specifying the names of the time-varying covariates in \code{obs_data}.}

\item{covtypes}{Vector of character strings specifying the "type" of each time-varying covariate included in \code{covnames}. The possible "types" are: \code{"binary"}, \code{"normal"}, \code{"categorical"}, \code{"bounded normal"}, \code{"zero-inflated normal"}, \code{"truncated normal"}, \code{"absorbing"}, \code{"categorical time"}, and \code{"custom"}.}

\item{nat_pool}{Pooled-over-time data table containing simulated data under the natural course.}

\item{nat_result}{Vector containing the mean outcome over all subjects at each time for natural course.}

\item{comprisk}{Logical scalar indicating the presence of a competing event.}

\item{comprisk2}{Logical scalar indicating whether competing events are treated as censoring events.}

\item{censor}{Logical scalar indicating the presence of a censoring variable in \code{obs_data}.}

\item{fitD2}{Model fit for the competing event variable if competing events are treated as censoring events.}

\item{fitC}{Model fit for the censoring variable.}

\item{outcome_type}{Character string specifying the "type" of the outcome. The possible "types" are: \code{"survival"}, \code{"continuous_eof"}, and \code{"binary_eof"}.}

\item{obs_data}{Data table containing observed data.}

\item{ipw_cutoff_quantile}{Percentile by which to truncate inverse probability weights.}

\item{ipw_cutoff_value}{Cutoff value by which to truncate inverse probability weights.}
}
\value{
A list with the following components:
\item{obs_results}{A list of the mean observed values at each time point for covariates and - if the outcome is of type \code{"survival"} - the risk and survival.}
\item{dt_cov_plot}{A list of data tables The data tables contain the observed and simulated mean values of the covariates under each time point.}
\item{dt_obs_plot}{For outcomes of type \code{"survival"}, a list of data tables. The data tables contain the observed and simulated risks and survival under each time point. For other outcomes, a value of \code{NA} is given.}
}
\description{
This internal function obtains the data tables necessary for plotting. For continuous and binary covariates, the mean observed and simulated values are obtained for each time point. For categorical covariates, the observed and simulated means of the levels of the factors are obtained for each time point.  When the outcome is of type \code{"survival"}, the observed and simulated risk and survival are obtained for each time point.
}
\keyword{internal}
