% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge_with_metadata.R
\name{reverse_sequence_if_needed}
\alias{reverse_sequence_if_needed}
\title{Reverse sequences if needed (\code{\link[=merge_methylation_with_metadata]{merge_methylation_with_metadata()}} helper)}
\usage{
reverse_sequence_if_needed(
  sequence_vector,
  direction_vector,
  output_mode = "DNA"
)
}
\arguments{
\item{sequence_vector}{\verb{character vector}. The DNA or RNA sequences to be reversed, e.g. \code{c("ATCG", "GGCGGC", "AUUAUA")}. Accepts DNA, RNA, or mixed input.}

\item{direction_vector}{\verb{character vector}. Whether each sequence is forward or reverse. Must contain only \code{"forward"} and \code{"reverse"}, but is not case sensitive. Must be the same length as \code{sequence_vector}.}

\item{output_mode}{\code{character}. Whether reverse-complemented sequences should be converted to DNA (i.e. A complements to T) or RNA (i.e. A complements to U). Must be either \code{"DNA"} or \code{"RNA"}. \emph{Only affects reverse-complemented sequences. Sequences that were forward to begin with are not altered.}}
}
\value{
\verb{character vector}. A vector of all forward versions of the input sequence vector.
}
\description{
This function takes a vector of DNA/RNA sequences and a vector of directions
(which must all be either \code{"forward"} or \code{"reverse"}, \emph{not} case-sensitive)
and returns a vector of forward DNA/RNA sequences.\cr\cr
Sequences in the vector that were forward to begin with are unchanged,
while sequences that were reverse are reverse-complemented via \code{\link[=reverse_complement]{reverse_complement()}}
to produce the forward sequence.\cr\cr
Called by \code{\link[=merge_methylation_with_metadata]{merge_methylation_with_metadata()}} to create a forward dataset, alongside
\code{\link[=reverse_quality_if_needed]{reverse_quality_if_needed()}}, \code{\link[=reverse_locations_if_needed]{reverse_locations_if_needed()}} and \code{\link[=reverse_probabilities_if_needed]{reverse_probabilities_if_needed()}}.
}
\examples{
reverse_sequence_if_needed(
    sequence_vector = c("TAAGGC", "TAAGGC"),
    direction_vector = c("reverse", "forward")
)

reverse_sequence_if_needed(
    sequence_vector = c("UAAGGC", "UAAGGC"),
    direction_vector = c("reverse", "forward"),
    output_mode = "RNA"
)

}
