% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-arrowsegment.R
\name{geom_arrowsegment}
\alias{geom_arrowsegment}
\title{Line segments with flexible arrows}
\usage{
geom_arrowsegment(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  arrows = list(arrow()),
  arrow_fills = NULL,
  arrow_positions = 1,
  lineend = "butt",
  linejoin = "round",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used the override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{A position adjustment to use on the data for this layer. This
can be used in various ways, including to prevent overplotting and
improving the display. The \code{position} argument accepts the following:
\itemize{
\item The result of calling a position function, such as \code{position_jitter()}.
This method allows for passing extra arguments to the position.
\item A string naming the position adjustment. To give the position as a
string, strip the function name of the \code{position_} prefix. For example,
to use \code{position_jitter()}, give the position as \code{"jitter"}.
\item For more information and other ways to specify the position, see the
\link[ggplot2:layer_positions]{layer position} documentation.
}}

\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}'s \code{params} argument. These
arguments broadly fall into one of 4 categories below. Notably, further
arguments to the \code{position} argument, or aesthetics that are required
can \emph{not} be passed through \code{...}. Unknown arguments that are not part
of the 4 categories below are ignored.
\itemize{
\item Static aesthetics that are not mapped to a scale, but are at a fixed
value and apply to the layer as a whole. For example, \code{colour = "red"}
or \code{linewidth = 3}. The geom's documentation has an \strong{Aesthetics}
section that lists the available options. The 'required' aesthetics
cannot be passed on to the \code{params}. Please note that while passing
unmapped aesthetics as vectors is technically possible, the order and
required length is not guaranteed to be parallel to the input data.
\item When constructing a layer using
a \verb{stat_*()} function, the \code{...} argument can be used to pass on
parameters to the \code{geom} part of the layer. An example of this is
\code{stat_density(geom = "area", outline.type = "both")}. The geom's
documentation lists which parameters it can accept.
\item Inversely, when constructing a layer using a
\verb{geom_*()} function, the \code{...} argument can be used to pass on parameters
to the \code{stat} part of the layer. An example of this is
\code{geom_area(stat = "density", adjust = 0.5)}. The stat's documentation
lists which parameters it can accept.
\item The \code{key_glyph} argument of \code{\link[ggplot2:layer]{layer()}} may also be passed on through
\code{...}. This can be one of the functions described as
\link[ggplot2:draw_key]{key glyphs}, to change the display of the layer in the legend.
}}

\item{arrows}{Either an arrow generated by \code{\link[grid:arrow]{grid::arrow()}} of a list of such arrows. In
the former case or if the list has length 1, the arrowhead so defined is used every
time; otherwise the list is expected to have the same length as
\code{arrow_positions} and each segment defined by that argument is ended by the respective
element of this one. The default is \code{\link[grid:arrow]{grid::arrow()}} with default parameters.}

\item{arrow_fills}{A vector of fill colours for the arrowheads, behaves as
the \code{arrow_fill} option in \code{\link[ggplot2:geom_segment]{ggplot2::geom_segment}}. This will overrule a fill aesthetic in
the same way that specifying a single \code{fill} outside \code{aes} specification will.}

\item{arrow_positions}{A vector of distinct points on the unit interval. 0 is not
permitted but arbitrarily small values are; 1 is permitted. The default behaviour is that
arrowheads will be placed proportionally along the line connecting (\code{x}, \code{y})
to (\code{xend},\code{yend}) at these points.
In more detail: The first arrow segment begins at (\code{x}, \code{y}) and ends a proportional
distance along the straight line joining (\code{x}, \code{y}) and (\code{xend}, \code{yend}) equal to the first
entry of this vector. The second bridges the first two entries, and so on. If the final
entry is 1 then the last segment is an arrow (and hence usually an arrowhead will be
placed at the end of the line). If it is not, then  the last segment is simply a line.
These will be sorted into order from 0 to 1 if they are not already.}

\item{lineend}{Line end style (round, butt, square).}

\item{linejoin}{Line join style (round, mitre, bevel).}

\item{na.rm}{If \code{FALSE}, the default, missing values are removed with
a warning. If \code{TRUE}, missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}
}
\value{
A ggproto object
}
\description{
The basic \code{geom_arrowsegment()} is equivalent to \code{geom_segment(arrow = arrow())}.
(It is assumed that the user wants some kind of arrow.) The extended functionality
is to allow free placement of the arrowhead anywhere along the segment, and also
multiple arrowheads, and to allow a fill aesthetic (which will only be visible for
closed arrowheads).

The function works by dividing the line up into 1 or more segment grobs, each of
which is generated by \code{\link[grid:arrow]{grid::arrow()}} except potentially the last (the one closest
to the point (\code{xend}, \code{yend})). The vector \code{arrow_positions}, whose entries must
lie between 0 and 1, defines where each arrow segment ends, as a proportional
position along the line. If the last entry of \code{arrow_positions} is 1, then the last
grob has an arrow; otherwise it does not.

The function is designed with the expectation that arrows point from (\code{x}, \code{y}) to
(\code{xend}, \code{yend}) but the \code{arrows} argument will happily accept \code{arrow(ends = "first")}
or \code{arrow(ends = "both")} if you prefer. Just remember that the final segment is
only an arrow at all if the last entry of \code{arrow_positions} is 1.
}
\examples{

 library(ggplot2)
 library(magrittr)
 library(tidyr)

 # Generate some dummy data

 ten.points <- data.frame(line.no = rep(1:5, each = 2), x = runif(10), y = runif(10),
                          position = rep(c("start", "end"), 5))
 five.segments <- ten.points \%>\% pivot_wider(names_from = position, values_from = c(x,y))

 # Default behaviour

 ggplot(five.segments) +
    geom_point(data = ten.points, aes(x = x, y = y)) +
    geom_arrowsegment(aes(x = x_start, xend = x_end, y = y_start, yend = y_end))

 # Midpoint arrowheads

 ggplot(five.segments) +
    geom_point(data = ten.points, aes(x = x, y = y)) +
    geom_arrowsegment(aes(x = x_start, xend = x_end, y = y_start, yend = y_end),
                      arrow_positions = 0.5)

 # Double arrows

 ggplot(five.segments) +
    geom_point(data = ten.points, aes(x = x, y = y)) +
    geom_arrowsegment(aes(x = x_start, xend = x_end, y = y_start, yend = y_end),
                      arrow_positions = c(0.25, 0.75))

 # Double arrows, last arrowhead at the end point

 ggplot(five.segments) +
    geom_point(data = ten.points, aes(x = x, y = y)) +
    geom_arrowsegment(aes(x = x_start, xend = x_end, y = y_start, yend = y_end),
                      arrow_positions = c(0.25, 1))

 # Double arrowheads of varying appearance and position

 ggplot(five.segments) +
     geom_point(data = ten.points, aes(x = x, y = y)) +
     geom_arrowsegment(aes(x = x_start, xend = x_end, y = y_start, yend = y_end),
                       arrow_positions = c(0.25, 0.75),
                       arrows = list(arrow(angle = 45, type = "closed"),
                                     arrow(angle = 25, ends = "both")),
                       arrow_fills = "indianred")

}
