% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggscreeplot.r
\name{ggscreeplot}
\alias{ggscreeplot}
\title{Screeplot for Principal Components}
\usage{
ggscreeplot(
  pcobj,
  type = c("pev", "cev"),
  size = 4,
  shape = 19,
  color = "black",
  linetype = 1,
  linewidth = 1
)
}
\arguments{
\item{pcobj}{an object returned by \code{\link[stats]{prcomp}}, \code{\link[stats]{princomp}}, 
\code{\link[FactoMineR]{PCA}}, \code{\link[ade4]{dudi.pca}}, or \code{\link[MASS]{lda}}}

\item{type}{the type of scree plot, one of \code{c('pev', 'cev')}.
\code{'pev'} plots the proportion of explained variance, i.e. the eigenvalues divided by the trace. 
\code{'cev'} plots the cumulative proportion of explained variance, i.e. the partial sum of the first k eigenvalues divided by the trace.}

\item{size}{point size}

\item{shape}{shape of the points. Default: 19, a filled circle.}

\item{color}{color for points and line. Default: \code{"black"}.}

\item{linetype}{type of line}

\item{linewidth}{width of line}
}
\value{
A ggplot2 object with the aesthetics \code{x = PC, y = yvar}
}
\description{
Produces scree plots (Cattell, 1966) of the variance proportions explained by each dimension against dimension number from 
various PCA-like dimension reduction techniques.
}
\examples{
data(wine)
wine.pca <- prcomp(wine, scale. = TRUE)
ggscreeplot(wine.pca)

# show horizontal lines for 80, 90\% of cumulative variance
ggscreeplot(wine.pca, type = "cev") +
  geom_hline(yintercept = c(0.8, 0.9), color = "blue") 

# Make a fancy screeplot, higlighting the scree starting at component 4
data(crime)
crime.pca <- 
  crime |> 
  dplyr::select(where(is.numeric)) |>
  prcomp(scale. = TRUE)
  
(crime.eig <- crime.pca |> 
   broom::tidy(matrix = "eigenvalues"))

ggscreeplot(crime.pca) +
  stat_smooth(data = crime.eig |> dplyr::filter(PC>=4), 
              aes(x=PC, y=percent), method = "lm", 
              se = FALSE,
              fullrange = TRUE) 

}
\references{
Cattell, R. B. (1966). The Scree Test For The Number Of Factors. \emph{Multivariate Behavioral Research}, 1, 245–276.
}
