% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{df2mat}
\alias{df2mat}
\title{Convert a 3-column data.frame (dim1, dim2, value) to a 2-D matrix}
\arguments{
\item{df}{A \code{data.frame} representing a melted 2-D matrix, having columns dim1, dim2, and value}

\item{replace_na}{if not \code{NULL}, this numeric value will be used to replace any NAs in \code{df} in the
resulting matrix. This is useful if downstream code is not built to handle missing values.}
}
\value{
The matrix form of the keyed data.frame object
}
\description{
Convert a 3-column data.frame (dim1, dim2, value) to a 2-D matrix
}
\details{
There is virtually no input validation of \code{df}. You must pass a data.frame that has dim1, dim2, and value as
columns. Otherwise, it will not work as expected.

This is a much faster version of the acast function from \code{reshape2} that works only on 2-D matrix conversions.
}
\keyword{internal}
