% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/density.R
\name{bandwidth}
\alias{bandwidth}
\alias{bandwidth_nrd0}
\alias{bandwidth_nrd}
\alias{bandwidth_ucv}
\alias{bandwidth_bcv}
\alias{bandwidth_SJ}
\alias{bandwidth_dpi}
\title{Bandwidth estimators}
\usage{
bandwidth_nrd0(x, ...)

bandwidth_nrd(x, ...)

bandwidth_ucv(x, ...)

bandwidth_bcv(x, ...)

bandwidth_SJ(x, ...)

bandwidth_dpi(x, ...)
}
\arguments{
\item{x}{<\link{numeric}> Vector containing a sample.}

\item{...}{
  Arguments passed on to \code{\link[stats:bandwidth]{stats::bw.SJ}}
  \describe{
    \item{\code{nb}}{number of bins to use.}
    \item{\code{lower,upper}}{range over which to minimize.  The default is
    almost always satisfactory.  \code{hmax} is calculated internally
    from a normal reference bandwidth.}
    \item{\code{method}}{either \code{"ste"} ("solve-the-equation") or
    \code{"dpi"} ("direct plug-in").   Can be abbreviated.}
    \item{\code{tol}}{for method \code{"ste"}, the convergence tolerance for
    \code{\link[stats]{uniroot}}.  The default leads to bandwidth estimates
    with only slightly more than one digit accuracy, which is sufficient
    for practical density estimation, but possibly not for theoretical
    simulation studies.}
  }}
}
\value{
A single number giving the bandwidth
}
\description{
Bandwidth estimators for densities, used in the \code{bandwidth} argument
to density functions (e.g. \code{\link[=density_bounded]{density_bounded()}}, \code{\link[=density_unbounded]{density_unbounded()}}).

Supports \link[=auto_partial]{automatic partial function application} with
\link[=waiver]{waived arguments}.
}
\details{
These are loose wrappers around the corresponding \code{bw.}-prefixed functions
in \pkg{stats}. See, for example, \code{\link[=bw.SJ]{bw.SJ()}}.

\code{\link[=bandwidth_dpi]{bandwidth_dpi()}}, which is the default bandwidth estimator in \pkg{ggdist},
is the Sheather-Jones direct plug-in estimator, i.e. \code{bw.SJ(..., method = "dpi")}.

With the exception of \code{\link[=bandwidth_nrd0]{bandwidth_nrd0()}}, these estimators may fail in some
cases, often when a sample contains many duplicates. If they do they will
automatically fall back to \code{\link[=bandwidth_nrd0]{bandwidth_nrd0()}} with a warning. However, these
failures are typically symptomatic of situations where you should not want to
use a kernel density estimator in the first place (e.g. data with duplicates
and/or discrete data). In these cases consider using a dotplot (\code{\link[=geom_dots]{geom_dots()}})
or histogram (\code{\link[=density_histogram]{density_histogram()}}) instead.
}
\seealso{
\code{\link[=density_bounded]{density_bounded()}}, \code{\link[=density_unbounded]{density_unbounded()}}.
}
