% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom_interval.R
\name{geom_interval}
\alias{geom_interval}
\title{Multiple-interval plot (shortcut geom)}
\usage{
geom_interval(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  orientation = NA,
  interval_size_range = c(1, 6),
  interval_size_domain = c(1, 6),
  arrow = NULL,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  check.aes = TRUE,
  check.param = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this layer.
When using a \verb{geom_*()} function to construct a layer, the \code{stat}
argument can be used the override the default coupling between geoms and
stats. The \code{stat} argument accepts the following:
\itemize{
\item A \code{Stat} ggproto subclass, for example \code{StatCount}.
\item A string naming the stat. To give the stat as a string, strip the
function name of the \code{stat_} prefix. For example, to use \code{stat_count()},
give the stat as \code{"count"}.
\item For more information and other ways to specify the stat, see the
\link[ggplot2:layer_stats]{layer stat} documentation.
}}

\item{position}{<\link[ggplot2:ggplot2-ggproto]{Position} | \link[=character]{string}> Position adjustment,
either as a string, or the result of a call to a position adjustment function.
Setting this equal to \code{"dodge"} (\code{\link[ggplot2:position_dodge]{position_dodge()}}) or
\code{"dodgejust"} (\code{\link[=position_dodgejust]{position_dodgejust()}}) can be useful if you have overlapping geometries.}

\item{...}{Other arguments passed to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like \code{colour = "red"}
or \code{linewidth = 3} (see \strong{Aesthetics}, below). They may also be parameters
to the paired geom/stat.}

\item{orientation}{<\link[=character]{string}> Whether this geom is drawn horizontally or vertically. One of:
\itemize{
\item \code{NA} (default): automatically detect the orientation based on how the aesthetics
are assigned. Automatic detection works most of the time.
\item \code{"horizontal"} (or \code{"y"}): draw horizontally, using the \code{y} aesthetic to identify different
groups. For each group, uses the \code{x}, \code{xmin}, \code{xmax}, and \code{thickness} aesthetics to
draw points, intervals, and slabs.
\item \code{"vertical"} (or \code{"x"}): draw vertically, using the \code{x} aesthetic to identify different
groups. For each group, uses the \code{y}, \code{ymin}, \code{ymax}, and \code{thickness} aesthetics to
draw points, intervals, and slabs.
}
For compatibility with the base ggplot naming scheme for \code{orientation}, \code{"x"} can be used as an alias
for \code{"vertical"} and \code{"y"} as an alias for \code{"horizontal"} (\pkg{ggdist} had an \code{orientation} parameter
before base ggplot did, hence the discrepancy).}

\item{interval_size_range}{<length-2 \link{numeric}> This geom scales the raw size aesthetic values when
drawing interval and point sizes, as they tend to be too thick when using
the default settings of \code{\link[ggplot2:scale_size]{scale_size_continuous()}},
which give sizes with a range of \code{c(1, 6)}. The \code{interval_size_domain} value indicates the
input domain of raw size values (typically this should be equal to the value of the \code{range}
argument of the \code{\link[ggplot2:scale_size]{scale_size_continuous()}} function), and
\code{interval_size_range} indicates the desired output range of the size values (the min and max
of the actual sizes used to draw intervals). Most of the time it is not recommended to change
the value of this argument, as it may result in strange scaling of legends; this argument is
a holdover from earlier versions that did not have size aesthetics targeting the point and
interval separately. If you want to adjust the size of the interval or points separately,
you can also use the \code{linewidth} or \code{point_size} aesthetics; see \link{sub-geometry-scales}.}

\item{interval_size_domain}{<length-2 \link{numeric}> Minimum and maximum of the values of the \code{size} and \code{linewidth} aesthetics
that will be translated into actual sizes for intervals drawn according to \code{interval_size_range} (see the
documentation for that argument.)}

\item{arrow}{<\link{arrow} | \link{NULL}> Type of arrow heads to use on the interval, or \code{NULL} for no arrows.}

\item{na.rm}{<scalar \link{logical}> If \code{FALSE}, the default, missing values are removed with a warning. If \code{TRUE},
missing values are silently removed.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{check.aes, check.param}{If \code{TRUE}, the default, will check that
supplied parameters and aesthetics are understood by the \code{geom} or
\code{stat}. Use \code{FALSE} to suppress the checks.}
}
\value{
A \link[ggplot2:ggplot2-ggproto]{ggplot2::Geom} representing a multiple-interval geometry which can
be added to a \code{\link[ggplot2:ggplot]{ggplot()}} object.
}
\description{
Shortcut version of \code{\link[=geom_slabinterval]{geom_slabinterval()}} for creating multiple-interval plots.

\strong{Roughly equivalent to:}

\preformatted{geom_slabinterval(
  aes(
    datatype = "interval",
    side = "both"
  ),
  interval_size_range = c(1, 6),
  show_slab = FALSE,
  show_point = FALSE
)}
}
\details{
This geom wraps \code{\link[=geom_slabinterval]{geom_slabinterval()}} with defaults designed to produce
multiple-interval plots. Default aesthetic mappings are applied if the \code{.width} column
is present in the input data (e.g., as generated by the \code{\link[=point_interval]{point_interval()}} family of functions),
making this geom often more convenient than vanilla \link[ggplot2:ggplot2-package]{ggplot2} geometries when used with
functions like \code{\link[=median_qi]{median_qi()}}, \code{\link[=mean_qi]{mean_qi()}}, \code{\link[=mode_hdi]{mode_hdi()}}, etc.

Specifically, if \code{.width} is present in the input, \code{\link[=geom_interval]{geom_interval()}} acts
as if its default aesthetics are \code{aes(colour = forcats::fct_rev(ordered(.width)))}
}
\section{Aesthetics}{

The slab+interval \code{stat}s and \code{geom}s have a wide variety of aesthetics that control
the appearance of their three sub-geometries: the \strong{slab}, the \strong{point}, and
the \strong{interval}.

\strong{Positional aesthetics}

\itemize{
\item{\code{x}: x position of the geometry}
\item{\code{y}: y position of the geometry}
}

\strong{Interval-specific aesthetics}

\itemize{
\item{\code{xmin}: Left end of the interval sub-geometry (if \code{orientation = "horizontal"}).}
\item{\code{xmax}: Right end of the interval sub-geometry (if \code{orientation = "horizontal"}).}
\item{\code{ymin}: Lower end of the interval sub-geometry (if \code{orientation = "vertical"}).}
\item{\code{ymax}: Upper end of the interval sub-geometry (if \code{orientation = "vertical"}).}
}

\strong{Color aesthetics}

\itemize{
\item{\code{colour}: (or \code{color}) The color of the \strong{interval} and \strong{point} sub-geometries.
Use the \code{slab_color}, \code{interval_color}, or \code{point_color} aesthetics (below) to
set sub-geometry colors separately.}
\item{\code{fill}: The fill color of the \strong{slab} and \strong{point} sub-geometries. Use the \code{slab_fill}
or \code{point_fill} aesthetics (below) to set sub-geometry colors separately.}
\item{\code{alpha}: The opacity of the \strong{slab}, \strong{interval}, and \strong{point} sub-geometries. Use the \code{slab_alpha},
\code{interval_alpha}, or \code{point_alpha} aesthetics (below) to set sub-geometry colors separately.}
\item{\code{colour_ramp}: (or \code{color_ramp}) A secondary scale that modifies the \code{color}
scale to "ramp" to another color. See \code{\link[=scale_colour_ramp]{scale_colour_ramp()}} for examples.}
\item{\code{fill_ramp}: A secondary scale that modifies the \code{fill}
scale to "ramp" to another color. See \code{\link[=scale_fill_ramp]{scale_fill_ramp()}} for examples.}
}

\strong{Line aesthetics}

\itemize{
\item{\code{linewidth}: Width of the line used to draw the \strong{interval} (except with \code{\link[=geom_slab]{geom_slab()}}: then
it is the width of the \strong{slab}). With composite geometries including an interval and slab,
use \code{slab_linewidth} to set the line width of the \strong{slab} (see below). For \strong{interval}, raw
\code{linewidth} values are transformed according to the \code{interval_size_domain} and \code{interval_size_range}
parameters of the \code{geom} (see above).}
\item{\code{size}: Determines the size of the \strong{point}. If \code{linewidth} is not provided, \code{size} will
also determines the width of the line used to draw the \strong{interval} (this allows line width and
point size to be modified together by setting only \code{size} and not \code{linewidth}). Raw
\code{size} values are transformed according to the \code{interval_size_domain}, \code{interval_size_range},
and \code{fatten_point} parameters of the \code{geom} (see above). Use the \code{point_size} aesthetic
(below) to set sub-geometry size directly without applying the effects of
\code{interval_size_domain}, \code{interval_size_range}, and \code{fatten_point}.}
\item{\code{stroke}: Width of the outline around the \strong{point} sub-geometry.}
\item{\code{linetype}: Type of line (e.g., \code{"solid"}, \code{"dashed"}, etc) used to draw the \strong{interval}
and the outline of the \strong{slab} (if it is visible). Use the \code{slab_linetype} or
\code{interval_linetype} aesthetics (below) to set sub-geometry line types separately.}
}

\strong{Interval-specific color and line override aesthetics}

\itemize{
\item{\code{interval_colour}: (or \code{interval_color}) Override for \code{colour}/\code{color}: the color of the interval.}
\item{\code{interval_alpha}: Override for \code{alpha}: the opacity of the interval.}
\item{\code{interval_linetype}: Override for \code{linetype}: the line type of the interval.}
}

\strong{Deprecated aesthetics}

\itemize{
\item{\code{interval_size}: Use \code{interval_linewidth}.}
}

\strong{Other aesthetics} (these work as in standard \code{geom}s)

\itemize{
\item{\code{width}}
\item{\code{height}}
\item{\code{group}}
}

See examples of some of these aesthetics in action in \code{vignette("slabinterval")}.
Learn more about the sub-geom override aesthetics (like \code{interval_color}) in the
\link[ggdist]{scales} documentation. Learn more about basic ggplot aesthetics in
\code{vignette("ggplot2-specs")}.
}

\examples{

library(dplyr)
library(ggplot2)

theme_set(theme_ggdist())

data(RankCorr_u_tau, package = "ggdist")

# orientation is detected automatically based on
# use of xmin/xmax or ymin/ymax

RankCorr_u_tau \%>\%
  group_by(i) \%>\%
  median_qi(.width = c(.5, .8, .95, .99)) \%>\%
  ggplot(aes(y = i, x = u_tau, xmin = .lower, xmax = .upper)) +
  geom_interval() +
  scale_color_brewer()

RankCorr_u_tau \%>\%
  group_by(i) \%>\%
  median_qi(.width = c(.5, .8, .95, .99)) \%>\%
  ggplot(aes(x = i, y = u_tau, ymin = .lower, ymax = .upper)) +
  geom_interval() +
  scale_color_brewer()

}
\seealso{
See \code{\link[=stat_interval]{stat_interval()}} for the stat version, intended for
use on sample data or analytical distributions.
See \code{\link[=geom_slabinterval]{geom_slabinterval()}} for the geometry this shortcut is based on.

Other slabinterval geoms: 
\code{\link{geom_pointinterval}()},
\code{\link{geom_slab}()},
\code{\link{geom_spike}()}
}
\concept{slabinterval geoms}
