% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iplot_data.R
\name{iplot_data}
\alias{iplot_data}
\alias{coefplot_data}
\title{Internal function for grabbing and preparing iplot data.}
\usage{
iplot_data(
  object,
  .ci_level = 0.95,
  .keep = NULL,
  .drop = NULL,
  .dict = fixest::getFixest_dict(),
  .internal.only.i = TRUE,
  .i.select = 1,
  .aggr_es = NULL,
  .group = "auto",
  .vcov = NULL,
  .cluster = NULL,
  .se = NULL
)

coefplot_data(
  object,
  .ci_level = 0.95,
  .keep = NULL,
  .drop = NULL,
  .group = "auto",
  .dict = fixest::getFixest_dict(),
  .internal.only.i = FALSE,
  .i.select = 1,
  .aggr_es = "none",
  .vcov = NULL,
  .cluster = NULL,
  .se = NULL
)
}
\arguments{
\item{object}{A model object of class \code{fixest} or \code{fixest_multi}, where
the \code{i()} operator has been used to construct an interaction, or set of
interactions.}

\item{.ci_level}{A number between 0 and 1 indicating the desired confidence
level, Defaults to 0.95.}

\item{.keep}{Character vector used to subset the coefficients of interest.
Passed down to \code{fixest::iplot(..., keep = .keep)} and should take the form of
an acceptable regular expression.}

\item{.drop}{Character vector used to subset the coefficients of interest
(complement of \code{.keep}). Passed down to \code{fixest::iplot(..., drop = .drop)}
and should take the form of an acceptable regular expression.}

\item{.dict}{A dictionary (i.e. named character vector or a logical scalar).
Used for changing coefficient names. Defaults to the values in
\code{getFixest_dict()}. See the \code{?fixest::coefplot} documentation for more
information. Note: This argument applies dictionary changes directly to the
return object for \code{coefplot_data}. However, it is ignored for \code{iplot_data},
since we want to preserve the numeric ordering for potential event study
plots. (And imposing an ordered factor would create its own downstream
problems in the case of continuous plot features like ribbons.) Instead, any
dictionary replacement for \code{ggiplot} is deferred to the actual plot call and
applied directly to the labels.}

\item{.internal.only.i}{Logical variable used for some internal function
handling when passing on to coefplot/iplot.}

\item{.i.select}{Integer scalar, default is 1. In (gg)iplot, used to select
which variable created with i() to select. Only used when there are several
variables created with i. This is an index, just try increasing numbers to
hopefully obtain what you want. Passed down to
\code{fixest::iplot(..., i.select = .i.select)}}

\item{.aggr_es}{A keyword string or numeric sequence indicating whether the
aggregated mean treatment effects for some subset of the model should be
added as a column to the returned data frame. Passed to
\code{aggr_es(..., aggregation = "mean")}.}

\item{.group}{A list, default is missing. Each element of the list reports
the coefficients to be grouped while the name of the element is the group
name. Passed down to \code{fixest::coefplot(..., group = .group)}. Example of
valid uses:
\itemize{
\item group=list(group_name="pattern")
\item group=list(group_name=c("var_start", "var_end"))
\item group=list(group_name=1:2)
\item See the Details section of \code{?fixest::coefplot} for more.
}}

\item{.vcov, .cluster, .se}{Alternative options for adjusting the standard
errors of the model object on the fly. See \code{vcov.fixest} for details
(although note that the "." period prefix should be ignored in the latter's
argument documentation). Written here in superseding order; \code{.cluster} will
only be considered if \code{.vcov} is not null, etc.}
}
\value{
A data frame consisting of estimate values, confidence intervals,
relative x-axis positions, and other aesthetic information needed to draw
a ggplot2 object.
}
\description{
Grabs the underlying data used to construct \code{fixest::iplot},
with some added functionality and tweaks for the \code{ggiplot} equivalents.
}
\details{
This function is a wrapper around
\code{fixest::iplot(..., only.params = TRUE)}, but with various checks and tweaks
to better facilitate plotting with \code{ggplot2} and handling of complex object
types (e.g. lists of fixest_multi models)
}
\section{Functions}{
\itemize{
\item \code{coefplot_data()}: Internal function for grabbing and preparing coefplot data

}}
\examples{
library(fixest)

est_did = feols(y ~ x1 + i(period, treat, 5) | id+period,
                data = base_did)
iplot(est_did, only.params = TRUE) # The "base" version
iplot_data(est_did)                # The wrapper provided by this package

# Illustrative fixest_multi case, where the sample has been split by odd and
# even ID numbers.
est_split = feols(y ~ x1 + i(period, treat, 5) | id+period,
                  data = base_did, split = ~id\%\%2)
iplot(est_split, only.params = TRUE) # The "base" version
iplot_data(est_split)                # The wrapper provided by this package

}
\seealso{
\code{\link[fixest:coefplot]{fixest::iplot()}}, \code{\link[=aggr_es]{aggr_es()}}.
}
