% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gggap_legend.R
\name{gggap_legend}
\alias{gggap_legend}
\title{Add Legend to gggap()}
\usage{
gggap_legend(plot, margin = c(top = 200, right = 200, bottom = 200, left =
  200))
}
\arguments{
\item{plot}{A 'ggplot2' plot.}

\item{margin}{Margins around the text.}
}
\value{
A legend-added picture
}
\description{
Add a legend to a `ggplot2` plot modified by gggap().
}
\examples{
library(ggplot2)
mtcars$gear <- factor(mtcars$gear)
bp <- ggplot(
  data = mtcars,
  aes(x = gear, fill = gear)
) +
geom_bar() +
ggtitle("Number of Cars by Gears") +
xlab("Gears")
gggap(
  plot = bp,
  ylim = c(0, 16),
  segments = c(6, 8)
)
gggap_legend(
  plot = bp,
  margin = c(top = 1, right = 1, bottom = 1, left = 460)
)
}
