% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggPieDonut.R
\name{ggDonut}
\alias{ggDonut}
\title{Draw a Donut plot}
\usage{
ggDonut(
  data,
  mapping,
  addDonutLabel = TRUE,
  showRatio = TRUE,
  polar = TRUE,
  labelposition = 1,
  labelsize = 3,
  title = "",
  use.label = TRUE,
  use.labels = TRUE,
  alpha = 0.7,
  interactive = FALSE,
  palette = NULL,
  reverse = FALSE,
  xmin = 3,
  xmax = 4,
  start = 3 * pi/2,
  direction = 1,
  colour = "white",
  explode = NULL,
  explodePos = 0.5,
  ...
)
}
\arguments{
\item{data}{A data.frame}

\item{mapping}{Set of aesthetic mappings created by aes or aes_.}

\item{addDonutLabel}{A logical value. If TRUE, labels are added to the Donuts}

\item{showRatio}{A logical value. If TRUE, Ratios are added to the DonutLabels}

\item{polar}{A logical value. If TRUE, coord_polar() function will be added}

\item{labelposition}{A number indicating the label position}

\item{labelsize}{label size. default value is 3}

\item{title}{Plot title}

\item{use.label}{Logical. Whether or not use column label in case of labelled data}

\item{use.labels}{Logical. Whether or not use value labels in case of labelled data}

\item{alpha}{transparency of geom_rect}

\item{interactive}{A logical value. If TRUE, an interactive plot will be returned}

\item{palette}{A character string indicating the color palette}

\item{reverse}{If true, reverse palette colors}

\item{xmin}{minimum x position}

\item{xmax}{maximum x position}

\item{start}{offset of starting point from 12 o'clock in radians}

\item{direction}{1, clockwise; -1, counterclockwise}

\item{colour}{colour of geom_rect}

\item{explode}{number of donuts to explode}

\item{explodePos}{explode position}

\item{...}{further arguments to be passed to geom_rect_interactive}
}
\value{
An interactive Pie and Donut plot
}
\description{
Draw a Donut plot
}
\examples{
require(ggplot2)
require(ggiraph)
require(plyr)
ggDonut(browsers,aes(donuts=version,count=share))
ggDonut(browsers,aes(donuts=version,count=share),palette="Reds",explode=c(2,4,6),labelposition=0)
}
