% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggPoints.R
\name{ggPoints}
\alias{ggPoints}
\title{Make an interactive scatterplot with regression line(s)}
\usage{
ggPoints(
  data,
  mapping,
  smooth = TRUE,
  se = TRUE,
  method = "auto",
  formula = y ~ x,
  fullrange = FALSE,
  level = 0.95,
  use.count = FALSE,
  maxfactorno = 6,
  digits = 2,
  title = NULL,
  subtitle = NULL,
  caption = NULL,
  use.label = TRUE,
  use.labels = TRUE,
  tooltip = NULL,
  interactive = FALSE,
  ...
)
}
\arguments{
\item{data}{a data.frame}

\item{mapping}{Set of aesthetic mappings created by aes or aes_.}

\item{smooth}{Logical. Add regression lines to the scatter plot}

\item{se}{Logical. display confidence interval around linear regression? (TRUE by default)}

\item{method}{smoothing method (function) to use, eg. "lm", "glm", "gam", "loess", "rlm"}

\item{formula}{formula to use in smoothing function, eg. y ~ x, y ~ poly(x, 2), y ~ log(x)}

\item{fullrange}{should the fit span the full range of the plot, or just the data}

\item{level}{level of confidence interval to use (0.95 by default)}

\item{use.count}{Logical. If true use geom_count instead of geom_point_interactive}

\item{maxfactorno}{An integer. Maximum unique number of a numeric vector treated as a factor}

\item{digits}{integer indicating the number of decimal places}

\item{title}{The text for plot title}

\item{subtitle}{The text for plot subtitle}

\item{caption}{The text for plot caption}

\item{use.label}{Logical. Whether or not use column label in case of labelled data}

\item{use.labels}{Logical. Whether or not use value labels in case of labelled data}

\item{tooltip}{A character string of column name be included in tooltip. Default value is NULL}

\item{interactive}{A logical value. If TRUE, an interactive plot will be returned}

\item{...}{other arguments passed on to geom_point}
}
\description{
Make an interactive scatterplot with regression line(s)
}
\examples{
require(ggplot2)
require(ggiraph)
require(plyr)
ggPoints(aes(x=wt,y=mpg,fill=am),data=mtcars)
ggPoints(aes(x=wt,y=mpg),data=mtcars)
ggPoints(aes(x=wt,y=mpg,fill=am),data=mtcars,method="lm",interactive=TRUE)
ggPoints(aes(x=wt,y=mpg,color=am),data=mtcars,interactive=TRUE)
}
