% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-pcp-boxes.r
\name{geom_pcp_boxes}
\alias{geom_pcp_boxes}
\title{Generalized Parallel Coordinate plots}
\usage{
geom_pcp_boxes(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  boxwidth = 0.2,
  ...
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by \code{\link[ggplot2:aes]{aes()}}. If specified and
\code{inherit.aes = TRUE} (the default), it is combined with the default mapping
at the top level of the plot. You must supply \code{mapping} if there is no plot
mapping.}

\item{data}{The data to be displayed in this layer. There are three
options:

If \code{NULL}, the default, the data is inherited from the plot
data as specified in the call to \code{\link[ggplot2:ggplot]{ggplot()}}.

A \code{data.frame}, or other object, will override the plot
data. All objects will be fortified to produce a data frame. See
\code{\link[ggplot2:fortify]{fortify()}} for which variables will be created.

A \code{function} will be called with a single argument,
the plot data. The return value must be a \code{data.frame}, and
will be used as the layer data. A \code{function} can be created
from a \code{formula} (e.g. \code{~ head(.x, 10)}).}

\item{stat}{The statistical transformation to use on the data for this
layer, either as a \code{ggproto} \code{Geom} subclass or as a string naming the
stat stripped of the \code{stat_} prefix (e.g. \code{"count"} rather than
\code{"stat_count"})}

\item{position}{Position adjustment, either as a string naming the adjustment
(e.g. \code{"jitter"} to use \code{position_jitter}), or the result of a call to a
position adjustment function. Use the latter if you need to change the
settings of the adjustment.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with a warning. If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.
It can also be a named logical vector to finely select the aesthetics to
display.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics,
rather than combining with them. This is most useful for helper functions
that define both data and aesthetics and shouldn't inherit behaviour from
the default plot specification, e.g. \code{\link[ggplot2:borders]{borders()}}.}

\item{boxwidth}{width of the box for a level on a categorical axis, defaults to 0.2.}

\item{...}{other arguments passed on to \code{layer}. These are often aesthetics, used to set an aesthetic to a fixed value, like \code{color = 'red'} or \code{size = 3}. They may also be parameters to the paired geom/stat.}
}
\value{
a list consisting of a \code{\link[ggplot2:layer]{ggplot2::layer()}} object and its associated scales.
}
\description{
The \code{ggpcp} package for generalized parallel coordinate plots is implemented as a
\code{ggplot2} extension.
In particular, this implementation makes use of \code{ggplot2}'s layer framework,
allowing for a lot of flexibility in the choice and order of showing graphical elements.\tabular{ll}{
   \strong{command} \tab \strong{graphical element} \cr
   \code{geom_pcp} \tab line segments \cr
   \code{geom_pcp_axes} \tab vertical lines to represent all axes \cr
   \code{geom_pcp_box} \tab boxes for levels on categorical axes \cr
   \code{geom_pcp_labels} \tab labels for levels on categorical axes \cr
}


These \code{ggpcp} specific layers can be mixed with \code{ggplot2}'s regular geoms,
such as e.g. \code{\link[ggplot2:geom_point]{ggplot2::geom_point()}}, \code{\link[ggplot2:geom_boxplot]{ggplot2::geom_boxplot()}}, \code{\link[ggdensity:geom_hdr]{ggdensity::geom_hdr()}}, etc.
}
\section{About Parallel Coordinate Plots}{
Parallel coordinate plots are a multivariate visualization that allows several aspects of an
observed entity to be shown in a single plot. Each aspect is represented by a vertical
axis (giving the plot its name), values are marked on each of these axes. Values corresponding to the same entity are connected
by line segments between adjacent axes. This type of visualization was first
used by d’Ocagne (1985). Modern re-inventions go back to Inselberg (1985) and
Wegman (1990).
This implementation takes a more general approach in that it is also able to deal
with  categorical in the same principled way that allows a tracking of individual
observations across multiple dimensions.
}

\section{Data wrangling}{
The data pipeline feeding \code{geom_pcp} is implemented in a three-step modularized
form rather than in a \code{stat_pcp} function more typical for \code{ggplot2} extensions.
The three steps of data pre-processing are:\tabular{ll}{
   \strong{command} \tab \strong{data processing step} \cr
   \code{pcp_select} \tab variable selection (and horizontal ordering) \cr
   \code{pcp_scale} \tab (vertical) scaling of values \cr
   \code{pcp_arrange} \tab dealing with tie-breaks on categorical axes \cr
}


Note that these data processing steps are executed before the call to \code{ggplot2}
and the identity function is used by default in all of the \code{ggpcp} specific layers.
Besides the speed-up by only executing the processing steps once for all layers,
the separation has the additional benefit, that it provides the users with the
possibility to make specific choices at each step in the process. Additionally,
separation allows for a cleaner user interface: parameters affecting the data
preparation process can be moved to the relevant (set of) function(s) only, thereby
reducing the  number of arguments without any loss of functionality.
}

\examples{
library(ggplot2)
data(mtcars)
mtcars_pcp <- mtcars |>
  dplyr::mutate(
    cyl = factor(cyl),
    vs = factor(vs),
    am = factor(am),
    gear = factor(gear),
    carb = factor(carb)
  ) |>
  pcp_select(1:11) |>  # select everything
  pcp_scale() |>
  pcp_arrange()

 base <- mtcars_pcp |> ggplot(aes_pcp())


 # Just the base plot:
 base + geom_pcp()

 # with the pcp theme
 base + geom_pcp() + theme_pcp()

 # with boxplots:
 base +
  geom_pcp(aes(colour = cyl)) +
  geom_boxplot(aes(x = pcp_x, y = pcp_y),
   inherit.aes=FALSE,
   data = dplyr::filter(mtcars_pcp, pcp_class!="factor")) +
  theme_pcp()

# base plot with boxes and labels
 base +
  geom_pcp(aes(colour = cyl)) +
  geom_pcp_boxes() +
  geom_pcp_labels() +
  theme_pcp()
}
\references{
M. d’Ocagne. (1885) \emph{Coordonnées parallèles et axiales: Méthode de transformation géométrique et procédé nouveau de calcul graphique déduits de la considération des coordonnées parallèles.} Gauthier-Villars, page 112, \url{https://archive.org/details/coordonnesparal00ocaggoog/page/n10}.

Al Inselberg. (1985) \emph{The plane with parallel coordinates.} The Visual Computer, 1(2):69–91,  \doi{10.1007/BF01898350}.

Ed J. Wegman. (1990) \emph{Hyperdimensional data analysis using parallel coordinates.} Journal of the American Statistical Association, 85:664–675, \doi{10.2307/2290001}.
}
