% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-functions.R
\name{stat_functions}
\alias{stat_functions}
\title{Draw functions as curves}
\usage{
stat_functions(
  mapping = NULL,
  data = NULL,
  n = 101,
  geom = "line",
  position = "identity",
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE,
  ...
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. Only needs to be
set at the layer level if you are overriding the plot defaults.}

\item{data}{A layer specific dataset. Useful if the function curve is to be
overlaid on other layers.}

\item{n}{integer Number of points to interpolate along the x axis.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use on this layer}

\item{na.rm}{a logical indicating whether \code{NA} values should be stripped
before the computation proceeds.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes it if any aesthetics are mapped.
\code{FALSE} never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}
}
\value{
A plot layer instance.
}
\description{
\code{stat_functions()} computes values from functions and returns new data
containing numeric vectors for \code{x} and \code{y}. As function definitions
are passed through \code{data} this statistic follows the grammar of graphics in
its behaviour.
}
\details{
This statistic can be used to plot values computed by functions. As
  it follows the grammar of graphics, grouping and facets are supported. In
  this it differs from \code{\link[ggplot2]{geom_function}} which behaves
  like a plot annotation.

  Aesthetics \code{xmin} and \code{xmax} should be mapped to numeric values
  defining the range of the vector to be created and passed as argument to
  the function to compute the \code{y} values, and returned as \code{x} in
  data. \code{n} is the length of this \code{x} vector.
}
\section{Computed variables}{
 Data frame with \code{n} rows or a multiple of
  this, one for each
  row in \code{data}. \describe{
  \item{x}{numeric vector}
  \item{y}{numeric vactor}
  \item{idx}{integer vector, with values corresponding to rows in the input
      \code{data}, i.e., for each function}
  }
  As shown in one example below \code{\link[gginnards]{geom_debug}} can be
  used to print the computed values returned by any statistic. The output
  shown includes also values mapped to aesthetics.
}

\examples{

# one function

df1 <- data.frame(min = 0, max = pi, fun = I(list(sin)))

ggplot(df1, aes(xmin = min, xmax = max, y = fun)) +
  stat_functions()

ggplot(df1, aes(xmin = min, xmax = max, y = fun)) +
  stat_functions(geom = "point", n = 20)

# two functions

df2 <- data.frame(min = -pi, max = pi,
                  fun = I(list(sin, cos)), name = c("sin", "cos"))

# each function must be in a separate group for correct plotting of lines

ggplot(df2, aes(xmin = min, xmax = max, y = fun, group = after_stat(idx))) +
  stat_functions()

ggplot(df2, aes(xmin = min, xmax = max, y = fun, colour = name)) +
  stat_functions()

ggplot(df2, aes(xmin = min, xmax = max, y = fun)) +
  stat_functions() +
  facet_grid(~ name)

# two curves with same function

df3 <- data.frame(min = c(-pi, 0),
                  max = c(0,pi),
                  fun = I(list(sin, sin)),
                  name = c("negative", "positive"))

ggplot(df3, aes(xmin = min, xmax = max, y = fun, colour = name)) +
  stat_functions()

# We use geom_debug_group() to see the computed values

gginnards.installed <- requireNamespace("gginnards", quietly = TRUE)
if (gginnards.installed) {
  library(gginnards)

  ggplot(df1, aes(xmin = min, xmax = max, y = fun)) +
    stat_functions(geom = "debug_group")
}

}
