% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rescale_coordinates.R
\name{rescale_coordinates}
\alias{rescale_coordinates}
\alias{rescale_international}
\title{Rescale x-y coordinates}
\usage{
rescale_coordinates(from, to)

rescale_international(from)
}
\arguments{
\item{from}{The dimensions to convert from (see \code{help(dimensions)})}

\item{to}{The dimensions to convert to (see \code{help(dimensions)})}
}
\description{
Returns a list containing 2 functions to translate x and y coordinates,
from one set of pitch dimensions (i.e. data provider) to another.

Any x or y coordinate is rescaled linearly between the nearest two pitch markings.
For example, the edge of the penalty box and the half way-line.
}
\details{
\code{pitch_international} creates a rescaler to \code{pitch_international}
coordinates.
}
\examples{

opta_to_wyscout <- rescale_coordinates(
  from = pitch_opta,
  to   = pitch_wyscout
)

opta_xs <- c(10, 22, 55, 78)
opta_ys <- c(10, 22, 55, 78)

opta_to_wyscout$x(opta_xs)
#> c(9.75000, 21.15152, 55.15152, 78.84848)

opta_to_wyscout$y(opta_ys)
#> c(9.004739, 20.031847, 55.172414, 79.968153)

}
