% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/histograms.R
\name{gghistweight3d}
\alias{gghistweight3d}
\title{Weighted Histogram with Two Facets}
\usage{
gghistweight3d(df, x, y, z, weights, binwidth = NULL)
}
\arguments{
\item{df}{data frame}

\item{x}{first variable of interest}

\item{y}{first categorical variable for faceting}

\item{z}{second categorical variable for faceting}

\item{weights}{survey weights that sum to sample size}

\item{binwidth}{desired binwidth, if NULL bins in geom_histogram defaults to 30}
}
\value{
ggplot object
}
\description{
In ggsurvey you specify both the plotting variables and weights in plain text with no quotes.
}
\examples{
library(survey)
data(api)
gghistweight3d(apistrat, api00, stype, awards, pw)
gghistweight3d(apistrat, api00, stype, awards, pw, binwidth = 10)
}
