% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggtern-package.R
\name{ggtern_package}
\alias{ggtern_package}
\alias{ggtern-package}
\title{Ternary Diagrams in R}
\description{
Ternary diagrams are used frequently in a number of disciplines to graph compositional features for mixtures of three different elements or compounds. 
It is possible to represent a coordinate system having three (3) degrees of freedom, in 2D space, since the third dimention is linear and depends only 
on the other two. 

The \code{ggtern} package is based on (extends) the very popular \code{\link[ggplot2:ggplot]{ggplot2}} package, which is an implementation of Wilkinsons 
"The Grammar of Graphics", and, makes provision for a highly methodical construction process for the development 
of meaningful (graphical) data representations. Of course, the above book by Wilkinson outlines the \emph{theory}, 
whilst Hadley Wickhams \code{\link[ggplot2:ggplot]{ggplot2}} implementation is where much of the magic happens, 
and, an ideal base-platform for the \code{ggtern} package.

In this document, some of the main features are highlighted, however, current examples (and corresponding outputs) 
can be viewed at http://ggtern.com
}
\section{\code{ggtern} Constructor}{

Plots in \code{ggtern} are instigated via the default constructor: \code{ggtern(...)}, 
for additional information, click \link[ggtern:ggtern]{HERE}:
}

\section{\code{ggtern} Ternary Coordinate System}{

The foundation of this package, is the ternary coordinate system, which can be produced with the \code{coord_tern(...)} command and added to an existing 
ggplot object. The \code{ggtern(...)} constructor adds the \code{coord_tern(...)} coordinate system by default. 
For further information on the \code{coord_tern(...)} coordinate system, click \link[ggtern:coord_tern]{HERE}.
}

\section{\code{ggtern} Valid Geometries}{

ggplot2, using the \code{\link{grid}} and \code{\link[proto]{proto}} architectures, makes provision for a many number of geometries to be added 
progressively in \emph{'layers'} to a given base plot. Due to the nature of the ternary coordinate system, some of the 
geometries which are available in ggplot2, are \strong{not relevant} (or won't function) with ternary plots and as such, a limited number of 
'approved' geometries can be used. Click \link[=approved_layers]{HERE} for the full list of approved geometries.

Notably, \code{ggtern} includes novel geometries not available to \code{ggplot2} which include:
\enumerate{
  \item \code{\link[=geom_confidence]{Confidence Intervals via the Mahalnobis Distance}}
  \item \code{\link[=geom_errorbarT]{Ternary Errorbars}}
  \item \code{\link[=geom_Tline]{Ternary Constant-Lines}}
}
}

\section{\code{ggtern} Handling Non-Approved Geometries}{

If a geometric layer is added that is \strong{NOT} contained in the approved \link[=approved_layers]{list}, \strong{IT WILL BE STRIPPED / IGNORED} from the ternary diagram 
when rendering takes place (notifying the user to such effect). The reason for this is that subtle 'patches' have been applied, which are mainly to do with 
the transformation procedures when incorporating a 'third' dimention. \strong{NB:} In the future, others may be made available once patched.
}

\section{\code{ggtern} New Theme Elements and Heirarchies}{

\code{ggtern} implements many new theme elements and heirarchies which can be tailored on a case-by-case basis. 
The full list of new elements can is provided \link[=theme_elements]{HERE}.
}

\section{\code{ggtern} Theme Element Convenience Functions}{

\code{ggtern} has made available a number of convenience functions, for rapid tweaking of common theme elements, for a comprehensive list, 
see \link[=theme_convenience]{HERE}.
}

\section{\code{ggtern} Modification to Required Aesthetics}{

Each geometry has a pre-determined set of \strong{required} aesthetics. These have been modifid such that where \code{x} and \code{y} were previously 
required, now an additional \code{z} aesthetic is required (\code{geom_segment} now requires \code{z} and \code{zend}). 
This is made possible without affecting the standard ggplot2 behaviour because \code{ggtern} distinuishes between \code{\link[=ggplot]{ggplot2}} and 
\code{ggtern} objects, distinguished by the presence of the \code{coord_tern(...)} coordinate system.
}

\section{\code{ggtern} Provided Datasets}{

\code{ggtern} ships with a number of datasets, including:
\enumerate{
  \item \code{\link[=data_Feldspar]{Elkin and Groves Feldspar Data}}
  \item \code{\link[=data_USDA]{USDA Textural Classification Data}}
  \item \code{\link[=data_Fragments]{Grantham and Valbel Rock Fragment Data}}
}
}

\examples{
##-----------------------------------------------
## Basic Usage
##-----------------------------------------------
df = data.frame(x = runif(50),
                y = runif(50),
                z = runif(50),
                Value = runif(50,1,10),
                Group = as.factor(round(runif(50,1,2))))
ggtern(data=df,aes(x,y,z,color=Group)) + 
  theme_rgbw() + 
  geom_point() + geom_path() + 
  labs(x="X",y="Y",z="Z",title="Title")

}
\references{
To cite this package, please use the following:

Hamilton NE and Ferry M (2018). "ggtern: Ternary Diagrams Using ggplot2." 
Journal of Statistical Software, Code Snippets, 87(3), pp. 1-17. 
doi: 10.18637/jss.v087.c03 (URL:http://doi.org/10.18637/jss.v087.c03)

A bibtex entry can be obtained by executing the following command:
\code{citation('ggtern')}
}
\author{
Nicholas Hamilton
}
