% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predFit.R
\name{predFit}
\alias{predFit}
\alias{predFit.default}
\alias{predFit.nls}
\title{Predictions from a Fitted Model}
\usage{
predFit(object, ...)

\method{predFit}{default}(object, ...)

\method{predFit}{nls}(
  object,
  newdata,
  se.fit = FALSE,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  adjust = c("none", "Bonferroni", "Scheffe"),
  k,
  ...
)
}
\arguments{
\item{object}{An object that inherits from class \code{"lm"}, \code{"nls"}.}

\item{...}{Additional optional arguments. At present, no optional arguments
are used.}

\item{newdata}{An optional data frame in which to look for variables with
which to predict. If omitted, the fitted values are used.}

\item{se.fit}{A logical vaue indicating if standard errors are required.
Default is \code{FALSE}.}

\item{interval}{Type of interval to be calculated. Can be one of "none"
(default), "confidence", or "prediction". Default is \code{"none"}.}

\item{level}{A numeric scalar between 0 and 1 giving the confidence level for
the intervals (if any) to be calculated. Default is \code{0.95}.}

\item{adjust}{A logical value indicating if an adjustment should be made to
the critical value used in calculating the confidence interval. This is
useful for when the calibration curve is to be used multiple, say k, times.
Default is \code{FALSE}.}

\item{k}{The number times the calibration curve is to be used for computing
a confidence/prediction interval. Only needed when
\code{adjust = "Bonferroni"}.}
}
\value{
No return value (called for side effects).
}
\description{
Generic prediction method for various types of fitted models. \code{predFit}
can be used to obtain standard errors of fitted values and
adjusted/unadjusted confidence/prediction intervals for objects of class
\code{"lm"}, \code{"nls"}.
}
\note{
predFit function is from 'investr' package written by Brandon M. Greenwell.
}
\references{
Greenwell B. M., and Schubert-Kabban, C. M. (2014)
\emph{investr: An R Package for Inverse Estimation}. The R Journal, 6(1), 90-100.
}
\seealso{
\code{\link[investr]{predFit}}
}
