% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commit.R
\name{commit}
\alias{commit}
\title{Commit changes using an auto-generated commit message}
\usage{
commit(commit_message, prepend)
}
\arguments{
\item{commit_message}{A custom commit message. If not provided, a message
will be generated automatically.}

\item{prepend}{A string to prepend to the commit message. Defaults to an
empty string. A convention may
be to prepend 'GPT: ' to the beginning of the commit message so you can
differentiate between those you wrote vs those GPT composed.}
}
\value{
No return value, called for side effects.
}
\description{
An R wrapper to automatically add, commit, and push changes
to a git repository using an auto-generated commit message. The commit
message is generated by an API call to the 'OpenAI' 'GPT-3.5 Turbo' model
using the git diff output as input.
}
\examples{
\dontrun{
  # Simple command to git add, git commit, and git push with a commit
  # message based on git diff of the working directory
  commit()
}

}
