% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projects_and_repos.R
\name{gl_get_commits}
\alias{gl_get_commits}
\alias{gl_get_diff}
\title{Get commits and diff from a project repository}
\usage{
gl_get_commits(project, commit_sha = c(), ...)

gl_get_diff(project, commit_sha, ...)
}
\arguments{
\item{project}{id (preferred way) or name of the project.
Not repository name.}

\item{commit_sha}{if not null, get only the commit with the specific hash; for
\code{gl_get_diff()} this must be specified}

\item{...}{passed on to \code{\link[=gitlab]{gitlab()}} API call, may contain
\code{ref_name} for specifying a branch or tag to list commits of}
}
\value{
Tibble of commits or diff of the branch with informative variables.
}
\description{
Get commits and diff from a project repository
}
\examples{
\dontrun{
my_commits <- gl_get_commits("<<your-project-id>>")
gl_get_commits("<<your-project-id>>", my_commits$id[1])
}
}
