% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/projects_and_repos.R
\name{gl_list_projects}
\alias{gl_list_projects}
\alias{gl_get_projects}
\alias{gl_list_user_projects}
\alias{gl_list_group_projects}
\alias{gl_get_project}
\title{List projects information}
\usage{
gl_list_projects(...)

gl_get_projects(...)

gl_list_user_projects(user_id, ...)

gl_list_group_projects(group_id, ...)

gl_get_project(project, ...)
}
\arguments{
\item{...}{passed on to \code{\link[=gitlab]{gitlab()}}}

\item{user_id}{id of the user to list project from}

\item{group_id}{id of the group to list project from}

\item{project}{id (preferred way) or name of the project.
Not repository name.}
}
\value{
tibble of each project with corresponding information
}
\description{
List projects information
}
\details{
\code{gl_list_projects()} is an alias for \code{gl_get_projects()}
}
\examples{
\dontrun{
set_gitlab_connection(
  gitlab_url = "https://gitlab.com",
  private_token = Sys.getenv("GITLAB_COM_TOKEN")
)
# List all projects
gl_get_projects(max_page = 1)
# List users projects
gl_list_user_projects(user_id = "<<user-id>>", max_page = 1)
# List group projects
gl_list_group_projects(group_id = "<<group-id>>", max_page = 1)
}
}
