% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getBeta.R
\name{getBeta}
\alias{getBeta}
\title{Beta optimization routing}
\usage{
getBeta(
  x,
  y,
  spt,
  ySptIndex,
  f0,
  linkinv,
  mu.eta,
  offset,
  sampprobs,
  betaStart,
  thStart,
  thetaControl = theta.control(),
  betaControl = beta.control()
)
}
\arguments{
\item{x}{Covariate matrix.}

\item{y}{Response vector.}

\item{spt}{Vector of unique observed support points in the response.}

\item{ySptIndex}{Index of each \code{y} value within the \code{spt} vector.}

\item{f0}{Current values of f0.}

\item{linkinv}{Inverse link function.}

\item{mu.eta}{Derivative of inverse link function.}

\item{offset}{Vector of known offset values to be added to the linear
combination (x' beta) for each observation. Mostly intended for likelihood ratio
and score confidence intervals.}

\item{sampprobs}{Optional matrix of sampling probabilities.}

\item{betaStart}{Starting values for beta (typically the estimates from the
previous iteration).}

\item{thStart}{Starting theta values. Needs to be a list of values matching
the output of the \code{getTheta} function.}

\item{thetaControl}{A "thetaControl" object returned from the \code{theta.control}
function.}

\item{betaControl}{A "betaControl" object returned from the \code{beta.control}
function.}
}
\value{
A list containing the following:
\itemize{
\item \code{beta} Updated values.
\item \code{mu} Updated mean for each observation.
\item \code{th} Updated list returned from the \code{getTheta} function.
\item \code{llik} Updated log-likelihood.
\item \code{iter} Number of iterations until convergence. (Will always be
one unless \code{maxiter} is increased to something greater than one using the
\code{betaControl} argument.)
\item \code{conv} Convergence indicator. (Will always be FALSE unless
\code{maxiter} is increased to something greater than one using the
\code{betaControl} argument.)
}
}
\description{
Beta optimization routing
}
\keyword{internal}
