% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est.R
\docType{data}
\name{est}
\alias{est}
\title{EST data -- Eastern Cooperative Oncology Group clinical trials, EST 2282}
\format{
A data frame with 191 rows and several variables:
\describe{
\item{Y}{Response variable representing the number of cancerous liver cells}
\item{Fetoprtn}{Alpha fetoprotein}
\item{BMI}{Body Mass Index}
\item{Antigen}{Anti-hepatitis B antigen}
\item{Jaundice}{Jaundice indicator, coded as 1 if present, 0 otherwise}
\item{Age}{Age in years}
\item{Weeks}{times in weeks}
\item{survive}{Dichotomized survival variable based on Y}
}
}
\source{
Generated for example purposes
}
\usage{
est
}
\description{
The dataset \code{est} is from the Eastern Cooperative Oncology Group clinical trials, specifically EST 2282 (Falkson, Cnaan, and Simson, 1990) and EST 1286 (Falkson et al., 1995). The dataset consists of 191 observations. It includes several covariates: Fetoprtn (alpha fetoprotein), Antigen (antihepatitis B antigen), Jaundice (a biochemical marker; coded as 1 if present, 0 otherwise), and Age (age in years). The response variable Y represents the number of cancerous liver cells present at the start of the clinical trial.

To assess the impact of these covariates on the likelihood of survival, a new variable called "survive" is created. "survive" is dichotomized based on Y: it is set to 1 if the number of cancerous liver cells is less than or equal to 8, and 0 otherwise.

Maiti and Pradhan (2009) fitted a logistic regression using the model \code{survive ~ Fetoprtn + Antigen + Jaundice + Age}. This model explores the relationship between the covariates and the likelihood of survival for patients in the clinical trials.
}
\examples{
data(est)
f_fit <- emforbeta(survive ~ Fetoprtn + Antigen + Jaundice + Age,
                   data = est,
                   family = binomial, method = "glm.fit")
summary(f_fit$mfit)

f_fit <- emforbeta(survive ~ Fetoprtn + Antigen + Jaundice + Age,
                   data = est,
                   family = binomial, method = "brglmFit")
summary(f_fit$mfit)

}
\references{
Cytel Inc (2010). LogXact 9 User Manual: Discrete Regression Analysis. Cambridge, Massachusetts: Cytel Inc.

Falkson, G., Lipsitz, S., Borden, E., Simson, I., W., and Haller, D. (1995). A ECOG randomized phase II study of beta interferon and Menogoril. American Journal of Clinical Oncology 18, 287–292.

Maiti, T., Pradhan, V. (2009). Bias reduction and a solution of separation of logistic regression with missing covariates. Biometrics, 65, 1262-1269.

Pradhan, V., Nychka, D. and Bandyopadhyay, S. (2025). Beyond the Odds: Fitting Logistic Regression with Missing Data in Small Samples (submitted).
}
\keyword{datasets}
