% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llkmiss.R
\name{llkmiss}
\alias{llkmiss}
\title{Fitting binary regression with missing categorical covariates using new likelihood based method that does not require EM algorithm}
\usage{
llkmiss(par, data, formula, augData, biasCorr = TRUE)
}
\arguments{
\item{par}{A vector including a list of parameters to be estimated. This include the beta (the regression parameters) and theta, the multinomial paraters for observing a missing covaraite pattern.}

\item{data}{Input data for fitting the model}

\item{formula}{A formula expression as for regression models, of the form \code{response ~ predictors}. The response should be a numeric binary variable with missing values, and predictors can be any variables. A predictor with categorical values with missing can be used in the model. See the documentation of formula for other details.}

\item{augData}{An augmented data including all possible covarites that could have been observed.}

\item{biasCorr}{a TRUE or FALSE value, by default it is TRUE.}
}
\value{
return the regression estimates
}
\description{
This function allows users to fit logistic regression models with incomplete predictors that are categorical. The model is fitted using a new likelihood-based method, which ensures reliable parameter estimation even when dealing with missing data. For more information on the underlying methodology, please refer to Pradhan, Nychka, and Bandyopadhyay (2025).
}
\references{
Firth, D. (1993). Bias reduction of maximum likelihood estimates, Biometrika, 80, 27-38. doi:10.2307/2336755.

Kosmidis, I., Firth, D. (2021). Jeffreys-prior penalty, finiteness and shrinkage in binomial-response generalized linear models. Biometrika, 108, 71-82. doi:10.1093/biomet/asaa052.

Pradhan, V., Nychka, D. and Bandyopadhyay, S. (2025). Bridging Gaps in Logistic Regression: Tackling Missing Categorical Covariates with a New Likelihood Method (to be submitted).

Pradhan, V., Nychka, D. and Bandyopadhyay, S. (2025). glmFitMiss: Binary Regression with Missing Data in R (to be submitted)
}
