% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/meningitis60ymis.R
\docType{data}
\name{meningitis60ymis}
\alias{meningitis60ymis}
\title{meningitis60ymis- Meningococcal Disease Data with missing data in the response variable}
\format{
A data frame with several rows and columns representing various variables:
\describe{
\item{CaseCntrl}{Case control status}
\item{Numnill}{Number of illnesses}
\item{Numsleep}{Number of sleep disturbances}
\item{R}{an indicator variable for missing CaseCntrl}
\item{Smoke}{Smoking status}
\item{Set}{Set variable}
\item{m}{indicator variable for observations with missing values}
\item{Reftime}{Reference time}
\item{resp}{Response variable with missing data for the varaible CaseCntrl}

}
}
\usage{
meningitis60ymis
}
\description{
The dataset meningitis is from a brief outbreak of meningococcal disease at the University of Illinois, Urbana-Champaign campus in the years 1991 and 1992. The dataset is available in the LogXact software and also analyzed in Imrey et al. (1996). Pradhan, Nychka and Bandyopadhyay (2024) fitted the model \code{resp~Numnill+Numsleep+Smoke+Set+Reftime}, where the the response variable resp included missing value.
}
\examples{
\donttest{
fit <- emBinRegMixedMAR(resp~Numnill+Numsleep+Smoke+Set+Reftime,
                        data=meningitis60ymis, biascorrectn=TRUE)
# display summary of the beta estimates of the model
fit$beta
# display summary of the alpha estimates of the model used
# for non-ignorability setting of the missing responses
fit$alpha
}
}
\references{
Cytel Inc (2010). LogXact 9 User Manual: Discrete Regression Analysis. Cambridge, Massachusetts: Cytel Inc.

Imrey, P. B., Jackson, L. A., Ludwinski, P. H., England, A. C. II, Fox, B. C., Isdale, L. B., Reeves, M. W., and Wenger, J. D. (1996). Outbreak of serogroup C meningococcal disease associated with campus bar patronage. American Journal of Epidemiology 143, 624–630.

Maiti, T., Pradhan, V. (2009). Bias reduction and a solution of separation of logistic regression with missing covariates. Biometrics, 65, 1262-1269.

Pradhan, V., Nychka, D. and Bandyopadhyay, S. (2025). Beyond the Odds: Fitting Logistic Regression with Missing Data in Small Samples (submitted).
}
\keyword{datasets}
