// Generated by rstantools.  Do not edit by hand.

/*
    glmmfields is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    glmmfields is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with glmmfields.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by stanc v2.26.1-4-gd72b68b7-dirty
#include <stan/model/model_header.hpp>
namespace model_glmmfields_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'glmmfields', line 42, column 2 to column 25)",
                                                      " (in 'glmmfields', line 43, column 2 to column 25)",
                                                      " (in 'glmmfields', line 44, column 2 to column 46)",
                                                      " (in 'glmmfields', line 45, column 2 to column 41)",
                                                      " (in 'glmmfields', line 46, column 2 to column 39)",
                                                      " (in 'glmmfields', line 47, column 2 to column 42)",
                                                      " (in 'glmmfields', line 48, column 2 to column 41)",
                                                      " (in 'glmmfields', line 49, column 2 to column 49)",
                                                      " (in 'glmmfields', line 50, column 2 to column 47)",
                                                      " (in 'glmmfields', line 51, column 2 to column 17)",
                                                      " (in 'glmmfields', line 52, column 2 to column 45)",
                                                      " (in 'glmmfields', line 53, column 2 to column 28)",
                                                      " (in 'glmmfields', line 56, column 2 to column 25)",
                                                      " (in 'glmmfields', line 57, column 2 to column 41)",
                                                      " (in 'glmmfields', line 58, column 2 to column 36)",
                                                      " (in 'glmmfields', line 59, column 2 to column 42)",
                                                      " (in 'glmmfields', line 60, column 2 to column 43)",
                                                      " (in 'glmmfields', line 61, column 2 to column 37)",
                                                      " (in 'glmmfields', line 62, column 2 to column 41)",
                                                      " (in 'glmmfields', line 63, column 2 to column 38)",
                                                      " (in 'glmmfields', line 64, column 2 to column 18)",
                                                      " (in 'glmmfields', line 65, column 2 to column 43)",
                                                      " (in 'glmmfields', line 66, column 2 to column 28)",
                                                      " (in 'glmmfields', line 67, column 2 to column 59)",
                                                      " (in 'glmmfields', line 71, column 4 to column 58)",
                                                      " (in 'glmmfields', line 73, column 4 to column 66)",
                                                      " (in 'glmmfields', line 69, column 21 to line 74, column 3)",
                                                      " (in 'glmmfields', line 69, column 2 to line 74, column 3)",
                                                      " (in 'glmmfields', line 77, column 4 to line 78, column 54)",
                                                      " (in 'glmmfields', line 80, column 4 to line 81, column 56)",
                                                      " (in 'glmmfields', line 75, column 21 to line 82, column 3)",
                                                      " (in 'glmmfields', line 75, column 2 to line 82, column 3)",
                                                      " (in 'glmmfields', line 86, column 6 to column 58)",
                                                      " (in 'glmmfields', line 87, column 6 to column 85)",
                                                      " (in 'glmmfields', line 89, column 6 to column 62)",
                                                      " (in 'glmmfields', line 90, column 6 to column 95)",
                                                      " (in 'glmmfields', line 84, column 29 to line 91, column 5)",
                                                      " (in 'glmmfields', line 84, column 4 to line 91, column 5)",
                                                      " (in 'glmmfields', line 94, column 6 to column 58)",
                                                      " (in 'glmmfields', line 95, column 6 to line 96, column 79)",
                                                      " (in 'glmmfields', line 98, column 6 to column 62)",
                                                      " (in 'glmmfields', line 99, column 6 to line 100, column 85)",
                                                      " (in 'glmmfields', line 92, column 29 to line 101, column 5)",
                                                      " (in 'glmmfields', line 92, column 4 to line 101, column 5)",
                                                      " (in 'glmmfields', line 83, column 21 to line 102, column 3)",
                                                      " (in 'glmmfields', line 83, column 2 to line 102, column 3)",
                                                      " (in 'glmmfields', line 104, column 4 to column 19)",
                                                      " (in 'glmmfields', line 103, column 22 to line 105, column 3)",
                                                      " (in 'glmmfields', line 103, column 2 to line 105, column 3)",
                                                      " (in 'glmmfields', line 107, column 2 to column 60)",
                                                      " (in 'glmmfields', line 109, column 4 to column 62)",
                                                      " (in 'glmmfields', line 108, column 18 to line 110, column 3)",
                                                      " (in 'glmmfields', line 108, column 2 to line 110, column 3)",
                                                      " (in 'glmmfields', line 121, column 8 to column 84)",
                                                      " (in 'glmmfields', line 120, column 20 to line 122, column 7)",
                                                      " (in 'glmmfields', line 120, column 6 to line 122, column 7)",
                                                      " (in 'glmmfields', line 124, column 8 to column 95)",
                                                      " (in 'glmmfields', line 123, column 19 to line 125, column 7)",
                                                      " (in 'glmmfields', line 123, column 6 to line 125, column 7)",
                                                      " (in 'glmmfields', line 119, column 11 to line 126, column 5)",
                                                      " (in 'glmmfields', line 117, column 8 to column 59)",
                                                      " (in 'glmmfields', line 116, column 13 to line 118, column 7)",
                                                      " (in 'glmmfields', line 115, column 8 to column 70)",
                                                      " (in 'glmmfields', line 114, column 32 to line 116, column 7)",
                                                      " (in 'glmmfields', line 114, column 6 to line 118, column 7)",
                                                      " (in 'glmmfields', line 113, column 29 to line 119, column 5)",
                                                      " (in 'glmmfields', line 113, column 4 to line 126, column 5)",
                                                      " (in 'glmmfields', line 127, column 4 to column 42)",
                                                      " (in 'glmmfields', line 112, column 17 to line 128, column 3)",
                                                      " (in 'glmmfields', line 112, column 2 to line 128, column 3)",
                                                      " (in 'glmmfields', line 130, column 4 to column 37)",
                                                      " (in 'glmmfields', line 129, column 20 to line 131, column 3)",
                                                      " (in 'glmmfields', line 129, column 2 to line 131, column 3)",
                                                      " (in 'glmmfields', line 228, column 2 to column 20)",
                                                      " (in 'glmmfields', line 232, column 6 to column 76)",
                                                      " (in 'glmmfields', line 231, column 24 to line 233, column 5)",
                                                      " (in 'glmmfields', line 231, column 4 to line 233, column 5)",
                                                      " (in 'glmmfields', line 235, column 6 to column 58)",
                                                      " (in 'glmmfields', line 234, column 24 to line 236, column 5)",
                                                      " (in 'glmmfields', line 234, column 4 to line 236, column 5)",
                                                      " (in 'glmmfields', line 245, column 8 to column 79)",
                                                      " (in 'glmmfields', line 240, column 13 to line 246, column 7)",
                                                      " (in 'glmmfields', line 239, column 8 to column 78)",
                                                      " (in 'glmmfields', line 238, column 33 to line 240, column 7)",
                                                      " (in 'glmmfields', line 238, column 6 to line 246, column 7)",
                                                      " (in 'glmmfields', line 237, column 24 to line 247, column 5)",
                                                      " (in 'glmmfields', line 237, column 4 to line 247, column 5)",
                                                      " (in 'glmmfields', line 249, column 6 to column 74)",
                                                      " (in 'glmmfields', line 248, column 24 to line 250, column 5)",
                                                      " (in 'glmmfields', line 248, column 4 to line 250, column 5)",
                                                      " (in 'glmmfields', line 252, column 6 to column 57)",
                                                      " (in 'glmmfields', line 251, column 24 to line 254, column 5)",
                                                      " (in 'glmmfields', line 251, column 4 to line 254, column 5)",
                                                      " (in 'glmmfields', line 256, column 6 to column 58)",
                                                      " (in 'glmmfields', line 255, column 24 to line 257, column 5)",
                                                      " (in 'glmmfields', line 255, column 4 to line 257, column 5)",
                                                      " (in 'glmmfields', line 230, column 17 to line 258, column 3)",
                                                      " (in 'glmmfields', line 230, column 2 to line 258, column 3)",
                                                      " (in 'glmmfields', line 135, column 2 to column 80)",
                                                      " (in 'glmmfields', line 136, column 2 to column 80)",
                                                      " (in 'glmmfields', line 138, column 4 to column 62)",
                                                      " (in 'glmmfields', line 137, column 20 to line 139, column 3)",
                                                      " (in 'glmmfields', line 137, column 2 to line 139, column 3)",
                                                      " (in 'glmmfields', line 142, column 4 to column 81)",
                                                      " (in 'glmmfields', line 140, column 17 to line 143, column 3)",
                                                      " (in 'glmmfields', line 140, column 2 to line 143, column 3)",
                                                      " (in 'glmmfields', line 147, column 6 to column 68)",
                                                      " (in 'glmmfields', line 145, column 22 to line 148, column 5)",
                                                      " (in 'glmmfields', line 145, column 4 to line 148, column 5)",
                                                      " (in 'glmmfields', line 144, column 17 to line 149, column 3)",
                                                      " (in 'glmmfields', line 144, column 2 to line 149, column 3)",
                                                      " (in 'glmmfields', line 152, column 4 to column 84)",
                                                      " (in 'glmmfields', line 154, column 4 to column 91)",
                                                      " (in 'glmmfields', line 156, column 6 to column 60)",
                                                      " (in 'glmmfields', line 155, column 20 to line 157, column 5)",
                                                      " (in 'glmmfields', line 155, column 4 to line 157, column 5)",
                                                      " (in 'glmmfields', line 151, column 27 to line 158, column 3)",
                                                      " (in 'glmmfields', line 151, column 2 to line 158, column 3)",
                                                      " (in 'glmmfields', line 165, column 6 to column 51)",
                                                      " (in 'glmmfields', line 164, column 16 to line 166, column 5)",
                                                      " (in 'glmmfields', line 164, column 4 to line 166, column 5)",
                                                      " (in 'glmmfields', line 163, column 9 to line 167, column 3)",
                                                      " (in 'glmmfields', line 161, column 4 to column 40)",
                                                      " (in 'glmmfields', line 162, column 4 to column 23)",
                                                      " (in 'glmmfields', line 160, column 19 to line 163, column 3)",
                                                      " (in 'glmmfields', line 160, column 2 to line 167, column 3)",
                                                      " (in 'glmmfields', line 182, column 4 to column 63)",
                                                      " (in 'glmmfields', line 188, column 8 to line 189, column 22)",
                                                      " (in 'glmmfields', line 187, column 13 to line 190, column 7)",
                                                      " (in 'glmmfields', line 185, column 8 to line 186, column 22)",
                                                      " (in 'glmmfields', line 184, column 24 to line 187, column 7)",
                                                      " (in 'glmmfields', line 184, column 6 to line 190, column 7)",
                                                      " (in 'glmmfields', line 183, column 20 to line 191, column 5)",
                                                      " (in 'glmmfields', line 183, column 4 to line 191, column 5)",
                                                      " (in 'glmmfields', line 181, column 9 to line 192, column 3)",
                                                      " (in 'glmmfields', line 170, column 4 to column 70)",
                                                      " (in 'glmmfields', line 177, column 8 to line 178, column 31)",
                                                      " (in 'glmmfields', line 176, column 13 to line 179, column 7)",
                                                      " (in 'glmmfields', line 174, column 8 to line 175, column 31)",
                                                      " (in 'glmmfields', line 173, column 24 to line 176, column 7)",
                                                      " (in 'glmmfields', line 173, column 6 to line 179, column 7)",
                                                      " (in 'glmmfields', line 172, column 20 to line 180, column 5)",
                                                      " (in 'glmmfields', line 172, column 4 to line 180, column 5)",
                                                      " (in 'glmmfields', line 168, column 14 to line 181, column 3)",
                                                      " (in 'glmmfields', line 168, column 2 to line 192, column 3)",
                                                      " (in 'glmmfields', line 198, column 4 to column 70)",
                                                      " (in 'glmmfields', line 199, column 4 to column 50)",
                                                      " (in 'glmmfields', line 196, column 22 to line 200, column 3)",
                                                      " (in 'glmmfields', line 196, column 2 to line 200, column 3)",
                                                      " (in 'glmmfields', line 202, column 4 to column 73)",
                                                      " (in 'glmmfields', line 203, column 4 to column 32)",
                                                      " (in 'glmmfields', line 201, column 22 to line 204, column 3)",
                                                      " (in 'glmmfields', line 201, column 2 to line 204, column 3)",
                                                      " (in 'glmmfields', line 206, column 4 to column 75)",
                                                      " (in 'glmmfields', line 211, column 63 to column 79)",
                                                      " (in 'glmmfields', line 211, column 8 to column 83)",
                                                      " (in 'glmmfields', line 210, column 21 to line 212, column 7)",
                                                      " (in 'glmmfields', line 210, column 6 to line 212, column 7)",
                                                      " (in 'glmmfields', line 209, column 11 to line 213, column 5)",
                                                      " (in 'glmmfields', line 208, column 6 to column 52)",
                                                      " (in 'glmmfields', line 207, column 31 to line 209, column 5)",
                                                      " (in 'glmmfields', line 207, column 4 to line 213, column 5)",
                                                      " (in 'glmmfields', line 205, column 22 to line 214, column 3)",
                                                      " (in 'glmmfields', line 205, column 2 to line 214, column 3)",
                                                      " (in 'glmmfields', line 216, column 4 to column 45)",
                                                      " (in 'glmmfields', line 215, column 22 to line 217, column 3)",
                                                      " (in 'glmmfields', line 215, column 2 to line 217, column 3)",
                                                      " (in 'glmmfields', line 219, column 4 to column 31)",
                                                      " (in 'glmmfields', line 218, column 22 to line 220, column 3)",
                                                      " (in 'glmmfields', line 218, column 2 to line 220, column 3)",
                                                      " (in 'glmmfields', line 222, column 4 to column 73)",
                                                      " (in 'glmmfields', line 223, column 4 to column 35)",
                                                      " (in 'glmmfields', line 221, column 22 to line 224, column 3)",
                                                      " (in 'glmmfields', line 221, column 2 to line 224, column 3)",
                                                      " (in 'glmmfields', line 2, column 2 to column 22)",
                                                      " (in 'glmmfields', line 3, column 2 to column 21)",
                                                      " (in 'glmmfields', line 4, column 2 to column 18)",
                                                      " (in 'glmmfields', line 5, column 2 to column 17)",
                                                      " (in 'glmmfields', line 6, column 8 to column 9)",
                                                      " (in 'glmmfields', line 6, column 2 to column 34)",
                                                      " (in 'glmmfields', line 7, column 8 to column 9)",
                                                      " (in 'glmmfields', line 7, column 2 to column 31)",
                                                      " (in 'glmmfields', line 8, column 8 to column 9)",
                                                      " (in 'glmmfields', line 8, column 2 to column 34)",
                                                      " (in 'glmmfields', line 9, column 8 to column 9)",
                                                      " (in 'glmmfields', line 9, column 2 to column 18)",
                                                      " (in 'glmmfields', line 10, column 8 to column 9)",
                                                      " (in 'glmmfields', line 10, column 2 to column 21)",
                                                      " (in 'glmmfields', line 11, column 8 to column 9)",
                                                      " (in 'glmmfields', line 11, column 2 to column 29)",
                                                      " (in 'glmmfields', line 12, column 2 to column 31)",
                                                      " (in 'glmmfields', line 13, column 2 to column 31)",
                                                      " (in 'glmmfields', line 14, column 2 to column 28)",
                                                      " (in 'glmmfields', line 15, column 2 to column 31)",
                                                      " (in 'glmmfields', line 16, column 2 to column 32)",
                                                      " (in 'glmmfields', line 17, column 2 to column 27)",
                                                      " (in 'glmmfields', line 18, column 2 to column 26)",
                                                      " (in 'glmmfields', line 19, column 9 to column 15)",
                                                      " (in 'glmmfields', line 19, column 17 to column 23)",
                                                      " (in 'glmmfields', line 19, column 2 to column 35)",
                                                      " (in 'glmmfields', line 20, column 9 to column 14)",
                                                      " (in 'glmmfields', line 20, column 16 to column 22)",
                                                      " (in 'glmmfields', line 20, column 2 to column 36)",
                                                      " (in 'glmmfields', line 21, column 2 to column 20)",
                                                      " (in 'glmmfields', line 22, column 9 to column 10)",
                                                      " (in 'glmmfields', line 22, column 12 to column 16)",
                                                      " (in 'glmmfields', line 22, column 2 to column 20)",
                                                      " (in 'glmmfields', line 23, column 2 to column 33)",
                                                      " (in 'glmmfields', line 24, column 2 to column 31)",
                                                      " (in 'glmmfields', line 25, column 2 to column 32)",
                                                      " (in 'glmmfields', line 26, column 2 to column 36)",
                                                      " (in 'glmmfields', line 27, column 2 to column 37)",
                                                      " (in 'glmmfields', line 28, column 2 to column 35)",
                                                      " (in 'glmmfields', line 29, column 2 to column 34)",
                                                      " (in 'glmmfields', line 30, column 2 to column 31)",
                                                      " (in 'glmmfields', line 31, column 2 to column 23)",
                                                      " (in 'glmmfields', line 32, column 2 to column 39)",
                                                      " (in 'glmmfields', line 33, column 2 to column 30)",
                                                      " (in 'glmmfields', line 34, column 2 to column 32)",
                                                      " (in 'glmmfields', line 35, column 2 to column 40)",
                                                      " (in 'glmmfields', line 36, column 2 to column 20)",
                                                      " (in 'glmmfields', line 37, column 2 to column 28)",
                                                      " (in 'glmmfields', line 38, column 2 to column 40)",
                                                      " (in 'glmmfields', line 39, column 2 to column 31)",
                                                      " (in 'glmmfields', line 44, column 8 to column 14)",
                                                      " (in 'glmmfields', line 45, column 8 to column 19)",
                                                      " (in 'glmmfields', line 46, column 8 to column 20)",
                                                      " (in 'glmmfields', line 47, column 8 to column 18)",
                                                      " (in 'glmmfields', line 48, column 8 to column 22)",
                                                      " (in 'glmmfields', line 49, column 8 to column 22)",
                                                      " (in 'glmmfields', line 50, column 8 to column 10)",
                                                      " (in 'glmmfields', line 50, column 19 to column 25)",
                                                      " (in 'glmmfields', line 51, column 9 to column 13)",
                                                      " (in 'glmmfields', line 52, column 8 to column 15)",
                                                      " (in 'glmmfields', line 53, column 8 to column 10)",
                                                      " (in 'glmmfields', line 56, column 9 to column 15)",
                                                      " (in 'glmmfields', line 57, column 8 to column 10)",
                                                      " (in 'glmmfields', line 57, column 19 to column 24)",
                                                      " (in 'glmmfields', line 58, column 9 to column 15)",
                                                      " (in 'glmmfields', line 58, column 17 to column 23)",
                                                      " (in 'glmmfields', line 59, column 9 to column 15)",
                                                      " (in 'glmmfields', line 59, column 17 to column 23)",
                                                      " (in 'glmmfields', line 60, column 9 to column 14)",
                                                      " (in 'glmmfields', line 60, column 16 to column 22)",
                                                      " (in 'glmmfields', line 61, column 9 to column 14)",
                                                      " (in 'glmmfields', line 61, column 16 to column 22)",
                                                      " (in 'glmmfields', line 62, column 9 to column 14)",
                                                      " (in 'glmmfields', line 62, column 16 to column 22)",
                                                      " (in 'glmmfields', line 63, column 9 to column 14)",
                                                      " (in 'glmmfields', line 63, column 16 to column 22)",
                                                      " (in 'glmmfields', line 64, column 9 to column 10)",
                                                      " (in 'glmmfields', line 65, column 8 to column 20)",
                                                      " (in 'glmmfields', line 228, column 9 to column 10)"};
#include <stan_meta_header.hpp>
class model_glmmfields final : public model_base_crtp<model_glmmfields> {
private:
  int nKnots;
  int nLocs;
  int nT;
  int N;
  std::vector<int> stationID;
  std::vector<int> yearID;
  std::vector<int> binomialN;
  std::vector<double> y;
  std::vector<int> y_int;
  std::vector<double> input_offset;
  std::vector<double> prior_gp_theta;
  std::vector<double> prior_gp_sigma;
  std::vector<double> prior_sigma;
  std::vector<double> prior_rw_sigma;
  std::vector<double> prior_intercept;
  std::vector<double> prior_beta;
  std::vector<double> prior_phi;
  Eigen::Matrix<double, -1, -1> distKnots;
  Eigen::Matrix<double, -1, -1> distKnots21;
  int nCov;
  Eigen::Matrix<double, -1, -1> X;
  int cov_func;
  int est_df;
  int est_phi;
  int norm_params;
  int gamma_params;
  int nb2_params;
  int obs_model;
  double fixed_df_value;
  double fixed_phi_value;
  int est_temporalRE;
  int n_year_effects;
  int lower_truncation;
  int fixed_intercept;
  double matern_kappa;
  int nW;
  double gp_sigma_scaling_factor;
  double df_lower_bound;
 
public:
  ~model_glmmfields() { }
  
  inline std::string model_name() const final { return "model_glmmfields"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = stanc3 v2.26.1-4-gd72b68b7-dirty", "stancflags = "};
  }
  
  
  model_glmmfields(stan::io::var_context& context__,
                   unsigned int random_seed__ = 0,
                   std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_glmmfields_namespace::model_glmmfields";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 175;
      context__.validate_dims("data initialization","nKnots","int",
          context__.to_vec());
      nKnots = std::numeric_limits<int>::min();
      
      current_statement__ = 175;
      nKnots = context__.vals_i("nKnots")[(1 - 1)];
      current_statement__ = 175;
      current_statement__ = 175;
      check_greater_or_equal(function__, "nKnots", nKnots, 1);
      current_statement__ = 176;
      context__.validate_dims("data initialization","nLocs","int",
          context__.to_vec());
      nLocs = std::numeric_limits<int>::min();
      
      current_statement__ = 176;
      nLocs = context__.vals_i("nLocs")[(1 - 1)];
      current_statement__ = 176;
      current_statement__ = 176;
      check_greater_or_equal(function__, "nLocs", nLocs, 1);
      current_statement__ = 177;
      context__.validate_dims("data initialization","nT","int",
          context__.to_vec());
      nT = std::numeric_limits<int>::min();
      
      current_statement__ = 177;
      nT = context__.vals_i("nT")[(1 - 1)];
      current_statement__ = 177;
      current_statement__ = 177;
      check_greater_or_equal(function__, "nT", nT, 1);
      current_statement__ = 178;
      context__.validate_dims("data initialization","N","int",
          context__.to_vec());
      N = std::numeric_limits<int>::min();
      
      current_statement__ = 178;
      N = context__.vals_i("N")[(1 - 1)];
      current_statement__ = 178;
      current_statement__ = 178;
      check_greater_or_equal(function__, "N", N, 1);
      current_statement__ = 179;
      validate_non_negative_index("stationID", "N", N);
      current_statement__ = 180;
      context__.validate_dims("data initialization","stationID","int",
          context__.to_vec(N));
      stationID = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 180;
      assign(stationID, nil_index_list(), context__.vals_i("stationID"),
        "assigning variable stationID");
      current_statement__ = 180;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 180;
        current_statement__ = 180;
        check_greater_or_equal(function__, "stationID[sym1__]",
                               stationID[(sym1__ - 1)], 1);}
      current_statement__ = 181;
      validate_non_negative_index("yearID", "N", N);
      current_statement__ = 182;
      context__.validate_dims("data initialization","yearID","int",
          context__.to_vec(N));
      yearID = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 182;
      assign(yearID, nil_index_list(), context__.vals_i("yearID"),
        "assigning variable yearID");
      current_statement__ = 182;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 182;
        current_statement__ = 182;
        check_greater_or_equal(function__, "yearID[sym1__]",
                               yearID[(sym1__ - 1)], 1);}
      current_statement__ = 183;
      validate_non_negative_index("binomialN", "N", N);
      current_statement__ = 184;
      context__.validate_dims("data initialization","binomialN","int",
          context__.to_vec(N));
      binomialN = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 184;
      assign(binomialN, nil_index_list(), context__.vals_i("binomialN"),
        "assigning variable binomialN");
      current_statement__ = 184;
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        current_statement__ = 184;
        current_statement__ = 184;
        check_greater_or_equal(function__, "binomialN[sym1__]",
                               binomialN[(sym1__ - 1)], 0);}
      current_statement__ = 185;
      validate_non_negative_index("y", "N", N);
      current_statement__ = 186;
      context__.validate_dims("data initialization","y","double",
          context__.to_vec(N));
      y = std::vector<double>(N, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 186;
      assign(y, nil_index_list(), context__.vals_r("y"),
        "assigning variable y");
      current_statement__ = 187;
      validate_non_negative_index("y_int", "N", N);
      current_statement__ = 188;
      context__.validate_dims("data initialization","y_int","int",
          context__.to_vec(N));
      y_int = std::vector<int>(N, std::numeric_limits<int>::min());
      
      current_statement__ = 188;
      assign(y_int, nil_index_list(), context__.vals_i("y_int"),
        "assigning variable y_int");
      current_statement__ = 189;
      validate_non_negative_index("input_offset", "N", N);
      current_statement__ = 190;
      context__.validate_dims("data initialization","input_offset","double",
          context__.to_vec(N));
      input_offset = std::vector<double>(N, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 190;
      assign(input_offset, nil_index_list(),
        context__.vals_r("input_offset"), "assigning variable input_offset");
      current_statement__ = 191;
      context__.validate_dims("data initialization","prior_gp_theta",
          "double",context__.to_vec(3));
      prior_gp_theta = std::vector<double>(3, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 191;
      assign(prior_gp_theta, nil_index_list(),
        context__.vals_r("prior_gp_theta"),
        "assigning variable prior_gp_theta");
      current_statement__ = 192;
      context__.validate_dims("data initialization","prior_gp_sigma",
          "double",context__.to_vec(3));
      prior_gp_sigma = std::vector<double>(3, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 192;
      assign(prior_gp_sigma, nil_index_list(),
        context__.vals_r("prior_gp_sigma"),
        "assigning variable prior_gp_sigma");
      current_statement__ = 193;
      context__.validate_dims("data initialization","prior_sigma","double",
          context__.to_vec(3));
      prior_sigma = std::vector<double>(3, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 193;
      assign(prior_sigma, nil_index_list(), context__.vals_r("prior_sigma"),
        "assigning variable prior_sigma");
      current_statement__ = 194;
      context__.validate_dims("data initialization","prior_rw_sigma",
          "double",context__.to_vec(3));
      prior_rw_sigma = std::vector<double>(3, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 194;
      assign(prior_rw_sigma, nil_index_list(),
        context__.vals_r("prior_rw_sigma"),
        "assigning variable prior_rw_sigma");
      current_statement__ = 195;
      context__.validate_dims("data initialization","prior_intercept",
          "double",context__.to_vec(3));
      prior_intercept = std::vector<double>(3, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 195;
      assign(prior_intercept, nil_index_list(),
        context__.vals_r("prior_intercept"),
        "assigning variable prior_intercept");
      current_statement__ = 196;
      context__.validate_dims("data initialization","prior_beta","double",
          context__.to_vec(3));
      prior_beta = std::vector<double>(3, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 196;
      assign(prior_beta, nil_index_list(), context__.vals_r("prior_beta"),
        "assigning variable prior_beta");
      current_statement__ = 197;
      context__.validate_dims("data initialization","prior_phi","double",
          context__.to_vec(3));
      prior_phi = std::vector<double>(3, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 197;
      assign(prior_phi, nil_index_list(), context__.vals_r("prior_phi"),
        "assigning variable prior_phi");
      current_statement__ = 198;
      validate_non_negative_index("distKnots", "nKnots", nKnots);
      current_statement__ = 199;
      validate_non_negative_index("distKnots", "nKnots", nKnots);
      current_statement__ = 200;
      context__.validate_dims("data initialization","distKnots","double",
          context__.to_vec(nKnots, nKnots));
      distKnots = Eigen::Matrix<double, -1, -1>(nKnots, nKnots);
      stan::math::fill(distKnots, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> distKnots_flat__;
        current_statement__ = 200;
        assign(distKnots_flat__, nil_index_list(),
          context__.vals_r("distKnots"),
          "assigning variable distKnots_flat__");
        current_statement__ = 200;
        pos__ = 1;
        current_statement__ = 200;
        for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
          current_statement__ = 200;
          for (int sym2__ = 1; sym2__ <= nKnots; ++sym2__) {
            current_statement__ = 200;
            assign(distKnots,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              distKnots_flat__[(pos__ - 1)], "assigning variable distKnots");
            current_statement__ = 200;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 201;
      validate_non_negative_index("distKnots21", "nLocs", nLocs);
      current_statement__ = 202;
      validate_non_negative_index("distKnots21", "nKnots", nKnots);
      current_statement__ = 203;
      context__.validate_dims("data initialization","distKnots21","double",
          context__.to_vec(nLocs, nKnots));
      distKnots21 = Eigen::Matrix<double, -1, -1>(nLocs, nKnots);
      stan::math::fill(distKnots21, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> distKnots21_flat__;
        current_statement__ = 203;
        assign(distKnots21_flat__, nil_index_list(),
          context__.vals_r("distKnots21"),
          "assigning variable distKnots21_flat__");
        current_statement__ = 203;
        pos__ = 1;
        current_statement__ = 203;
        for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
          current_statement__ = 203;
          for (int sym2__ = 1; sym2__ <= nLocs; ++sym2__) {
            current_statement__ = 203;
            assign(distKnots21,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              distKnots21_flat__[(pos__ - 1)],
              "assigning variable distKnots21");
            current_statement__ = 203;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 204;
      context__.validate_dims("data initialization","nCov","int",
          context__.to_vec());
      nCov = std::numeric_limits<int>::min();
      
      current_statement__ = 204;
      nCov = context__.vals_i("nCov")[(1 - 1)];
      current_statement__ = 204;
      current_statement__ = 204;
      check_greater_or_equal(function__, "nCov", nCov, 0);
      current_statement__ = 205;
      validate_non_negative_index("X", "N", N);
      current_statement__ = 206;
      validate_non_negative_index("X", "nCov", nCov);
      current_statement__ = 207;
      context__.validate_dims("data initialization","X","double",
          context__.to_vec(N, nCov));
      X = Eigen::Matrix<double, -1, -1>(N, nCov);
      stan::math::fill(X, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> X_flat__;
        current_statement__ = 207;
        assign(X_flat__, nil_index_list(), context__.vals_r("X"),
          "assigning variable X_flat__");
        current_statement__ = 207;
        pos__ = 1;
        current_statement__ = 207;
        for (int sym1__ = 1; sym1__ <= nCov; ++sym1__) {
          current_statement__ = 207;
          for (int sym2__ = 1; sym2__ <= N; ++sym2__) {
            current_statement__ = 207;
            assign(X,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              X_flat__[(pos__ - 1)], "assigning variable X");
            current_statement__ = 207;
            pos__ = (pos__ + 1);}}
      }
      current_statement__ = 208;
      context__.validate_dims("data initialization","cov_func","int",
          context__.to_vec());
      cov_func = std::numeric_limits<int>::min();
      
      current_statement__ = 208;
      cov_func = context__.vals_i("cov_func")[(1 - 1)];
      current_statement__ = 208;
      current_statement__ = 208;
      check_greater_or_equal(function__, "cov_func", cov_func, 0);
      current_statement__ = 208;
      current_statement__ = 208;
      check_less_or_equal(function__, "cov_func", cov_func, 2);
      current_statement__ = 209;
      context__.validate_dims("data initialization","est_df","int",
          context__.to_vec());
      est_df = std::numeric_limits<int>::min();
      
      current_statement__ = 209;
      est_df = context__.vals_i("est_df")[(1 - 1)];
      current_statement__ = 209;
      current_statement__ = 209;
      check_greater_or_equal(function__, "est_df", est_df, 0);
      current_statement__ = 209;
      current_statement__ = 209;
      check_less_or_equal(function__, "est_df", est_df, 1);
      current_statement__ = 210;
      context__.validate_dims("data initialization","est_phi","int",
          context__.to_vec());
      est_phi = std::numeric_limits<int>::min();
      
      current_statement__ = 210;
      est_phi = context__.vals_i("est_phi")[(1 - 1)];
      current_statement__ = 210;
      current_statement__ = 210;
      check_greater_or_equal(function__, "est_phi", est_phi, 0);
      current_statement__ = 210;
      current_statement__ = 210;
      check_less_or_equal(function__, "est_phi", est_phi, 1);
      current_statement__ = 211;
      context__.validate_dims("data initialization","norm_params","int",
          context__.to_vec());
      norm_params = std::numeric_limits<int>::min();
      
      current_statement__ = 211;
      norm_params = context__.vals_i("norm_params")[(1 - 1)];
      current_statement__ = 211;
      current_statement__ = 211;
      check_greater_or_equal(function__, "norm_params", norm_params, 0);
      current_statement__ = 211;
      current_statement__ = 211;
      check_less_or_equal(function__, "norm_params", norm_params, 1);
      current_statement__ = 212;
      context__.validate_dims("data initialization","gamma_params","int",
          context__.to_vec());
      gamma_params = std::numeric_limits<int>::min();
      
      current_statement__ = 212;
      gamma_params = context__.vals_i("gamma_params")[(1 - 1)];
      current_statement__ = 212;
      current_statement__ = 212;
      check_greater_or_equal(function__, "gamma_params", gamma_params, 0);
      current_statement__ = 212;
      current_statement__ = 212;
      check_less_or_equal(function__, "gamma_params", gamma_params, 1);
      current_statement__ = 213;
      context__.validate_dims("data initialization","nb2_params","int",
          context__.to_vec());
      nb2_params = std::numeric_limits<int>::min();
      
      current_statement__ = 213;
      nb2_params = context__.vals_i("nb2_params")[(1 - 1)];
      current_statement__ = 213;
      current_statement__ = 213;
      check_greater_or_equal(function__, "nb2_params", nb2_params, 0);
      current_statement__ = 213;
      current_statement__ = 213;
      check_less_or_equal(function__, "nb2_params", nb2_params, 1);
      current_statement__ = 214;
      context__.validate_dims("data initialization","obs_model","int",
          context__.to_vec());
      obs_model = std::numeric_limits<int>::min();
      
      current_statement__ = 214;
      obs_model = context__.vals_i("obs_model")[(1 - 1)];
      current_statement__ = 214;
      current_statement__ = 214;
      check_greater_or_equal(function__, "obs_model", obs_model, 0);
      current_statement__ = 214;
      current_statement__ = 214;
      check_less_or_equal(function__, "obs_model", obs_model, 6);
      current_statement__ = 215;
      context__.validate_dims("data initialization","fixed_df_value",
          "double",context__.to_vec());
      fixed_df_value = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 215;
      fixed_df_value = context__.vals_r("fixed_df_value")[(1 - 1)];
      current_statement__ = 215;
      current_statement__ = 215;
      check_greater_or_equal(function__, "fixed_df_value", fixed_df_value, 1);
      current_statement__ = 216;
      context__.validate_dims("data initialization","fixed_phi_value",
          "double",context__.to_vec());
      fixed_phi_value = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 216;
      fixed_phi_value = context__.vals_r("fixed_phi_value")[(1 - 1)];
      current_statement__ = 217;
      context__.validate_dims("data initialization","est_temporalRE","int",
          context__.to_vec());
      est_temporalRE = std::numeric_limits<int>::min();
      
      current_statement__ = 217;
      est_temporalRE = context__.vals_i("est_temporalRE")[(1 - 1)];
      current_statement__ = 217;
      current_statement__ = 217;
      check_greater_or_equal(function__, "est_temporalRE", est_temporalRE, 0);
      current_statement__ = 217;
      current_statement__ = 217;
      check_less_or_equal(function__, "est_temporalRE", est_temporalRE, 1);
      current_statement__ = 218;
      context__.validate_dims("data initialization","n_year_effects","int",
          context__.to_vec());
      n_year_effects = std::numeric_limits<int>::min();
      
      current_statement__ = 218;
      n_year_effects = context__.vals_i("n_year_effects")[(1 - 1)];
      current_statement__ = 218;
      current_statement__ = 218;
      check_greater_or_equal(function__, "n_year_effects", n_year_effects, 0);
      current_statement__ = 219;
      context__.validate_dims("data initialization","lower_truncation","int",
          context__.to_vec());
      lower_truncation = std::numeric_limits<int>::min();
      
      current_statement__ = 219;
      lower_truncation = context__.vals_i("lower_truncation")[(1 - 1)];
      current_statement__ = 219;
      current_statement__ = 219;
      check_greater_or_equal(function__, "lower_truncation",
                             lower_truncation, 0);
      current_statement__ = 220;
      context__.validate_dims("data initialization","fixed_intercept","int",
          context__.to_vec());
      fixed_intercept = std::numeric_limits<int>::min();
      
      current_statement__ = 220;
      fixed_intercept = context__.vals_i("fixed_intercept")[(1 - 1)];
      current_statement__ = 220;
      current_statement__ = 220;
      check_greater_or_equal(function__, "fixed_intercept", fixed_intercept,
                             0);
      current_statement__ = 220;
      current_statement__ = 220;
      check_less_or_equal(function__, "fixed_intercept", fixed_intercept, 1);
      current_statement__ = 221;
      context__.validate_dims("data initialization","matern_kappa","double",
          context__.to_vec());
      matern_kappa = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 221;
      matern_kappa = context__.vals_r("matern_kappa")[(1 - 1)];
      current_statement__ = 222;
      context__.validate_dims("data initialization","nW","int",
          context__.to_vec());
      nW = std::numeric_limits<int>::min();
      
      current_statement__ = 222;
      nW = context__.vals_i("nW")[(1 - 1)];
      current_statement__ = 222;
      current_statement__ = 222;
      check_greater_or_equal(function__, "nW", nW, 0);
      current_statement__ = 222;
      current_statement__ = 222;
      check_less_or_equal(function__, "nW", nW, nT);
      current_statement__ = 223;
      context__.validate_dims("data initialization",
          "gp_sigma_scaling_factor","double",context__.to_vec());
      gp_sigma_scaling_factor = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 223;
      gp_sigma_scaling_factor = context__.vals_r("gp_sigma_scaling_factor")[
          (1 - 1)];
      current_statement__ = 223;
      current_statement__ = 223;
      check_greater_or_equal(function__, "gp_sigma_scaling_factor",
                             gp_sigma_scaling_factor, 0);
      current_statement__ = 224;
      context__.validate_dims("data initialization","df_lower_bound",
          "double",context__.to_vec());
      df_lower_bound = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 224;
      df_lower_bound = context__.vals_r("df_lower_bound")[(1 - 1)];
      current_statement__ = 224;
      current_statement__ = 224;
      check_greater_or_equal(function__, "df_lower_bound", df_lower_bound, 1);
      current_statement__ = 225;
      validate_non_negative_index("df", "est_df", est_df);
      current_statement__ = 226;
      validate_non_negative_index("sigma", "norm_params", norm_params);
      current_statement__ = 227;
      validate_non_negative_index("CV", "gamma_params", gamma_params);
      current_statement__ = 228;
      validate_non_negative_index("nb2_phi", "nb2_params", nb2_params);
      current_statement__ = 229;
      validate_non_negative_index("yearEffects", "n_year_effects",
                                  n_year_effects);
      current_statement__ = 230;
      validate_non_negative_index("year_sigma", "est_temporalRE",
                                  est_temporalRE);
      current_statement__ = 231;
      validate_non_negative_index("spatialEffectsKnots", "nT", nT);
      current_statement__ = 232;
      validate_non_negative_index("spatialEffectsKnots", "nKnots", nKnots);
      current_statement__ = 233;
      validate_non_negative_index("B", "nCov", nCov);
      current_statement__ = 234;
      validate_non_negative_index("phi", "est_phi", est_phi);
      current_statement__ = 235;
      validate_non_negative_index("W", "nW", nW);
      current_statement__ = 236;
      validate_non_negative_index("muZeros", "nKnots", nKnots);
      current_statement__ = 237;
      validate_non_negative_index("spatialEffects", "nT", nT);
      current_statement__ = 238;
      validate_non_negative_index("spatialEffects", "nLocs", nLocs);
      current_statement__ = 239;
      validate_non_negative_index("SigmaKnots", "nKnots", nKnots);
      current_statement__ = 240;
      validate_non_negative_index("SigmaKnots", "nKnots", nKnots);
      current_statement__ = 241;
      validate_non_negative_index("transformed_dist", "nKnots", nKnots);
      current_statement__ = 242;
      validate_non_negative_index("transformed_dist", "nKnots", nKnots);
      current_statement__ = 243;
      validate_non_negative_index("transformed_dist21", "nLocs", nLocs);
      current_statement__ = 244;
      validate_non_negative_index("transformed_dist21", "nKnots", nKnots);
      current_statement__ = 245;
      validate_non_negative_index("SigmaOffDiag", "nLocs", nLocs);
      current_statement__ = 246;
      validate_non_negative_index("SigmaOffDiag", "nKnots", nKnots);
      current_statement__ = 247;
      validate_non_negative_index("SigmaOffDiagTemp", "nLocs", nLocs);
      current_statement__ = 248;
      validate_non_negative_index("SigmaOffDiagTemp", "nKnots", nKnots);
      current_statement__ = 249;
      validate_non_negative_index("invSigmaKnots", "nLocs", nLocs);
      current_statement__ = 250;
      validate_non_negative_index("invSigmaKnots", "nKnots", nKnots);
      current_statement__ = 251;
      validate_non_negative_index("y_hat", "N", N);
      current_statement__ = 252;
      validate_non_negative_index("gammaA", "gamma_params", gamma_params);
      current_statement__ = 253;
      validate_non_negative_index("log_lik", "N", N);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += est_df;
      num_params_r__ += norm_params;
      num_params_r__ += gamma_params;
      num_params_r__ += nb2_params;
      num_params_r__ += n_year_effects;
      num_params_r__ += est_temporalRE;
      num_params_r__ += nT * nKnots;
      num_params_r__ += nCov;
      num_params_r__ += est_phi;
      num_params_r__ += nW;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_glmmfields_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      local_scalar_t__ gp_theta;
      gp_theta = DUMMY_VAR__;
      
      current_statement__ = 1;
      gp_theta = in__.scalar();
      current_statement__ = 1;
      if (jacobian__) {
        current_statement__ = 1;
        gp_theta = stan::math::lb_constrain(gp_theta, 0, lp__);
      } else {
        current_statement__ = 1;
        gp_theta = stan::math::lb_constrain(gp_theta, 0);
      }
      local_scalar_t__ gp_sigma;
      gp_sigma = DUMMY_VAR__;
      
      current_statement__ = 2;
      gp_sigma = in__.scalar();
      current_statement__ = 2;
      if (jacobian__) {
        current_statement__ = 2;
        gp_sigma = stan::math::lb_constrain(gp_sigma, 0, lp__);
      } else {
        current_statement__ = 2;
        gp_sigma = stan::math::lb_constrain(gp_sigma, 0);
      }
      std::vector<local_scalar_t__> df;
      df = std::vector<local_scalar_t__>(est_df, DUMMY_VAR__);
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= est_df; ++sym1__) {
        current_statement__ = 3;
        assign(df, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable df");}
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= est_df; ++sym1__) {
        current_statement__ = 3;
        if (jacobian__) {
          current_statement__ = 3;
          assign(df, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(df[(sym1__ - 1)], df_lower_bound, lp__),
            "assigning variable df");
        } else {
          current_statement__ = 3;
          assign(df, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(df[(sym1__ - 1)], df_lower_bound),
            "assigning variable df");
        }}
      std::vector<local_scalar_t__> sigma;
      sigma = std::vector<local_scalar_t__>(norm_params, DUMMY_VAR__);
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= norm_params; ++sym1__) {
        current_statement__ = 4;
        assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma");}
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= norm_params; ++sym1__) {
        current_statement__ = 4;
        if (jacobian__) {
          current_statement__ = 4;
          assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma[(sym1__ - 1)], 0, lp__),
            "assigning variable sigma");
        } else {
          current_statement__ = 4;
          assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(sigma[(sym1__ - 1)], 0),
            "assigning variable sigma");
        }}
      std::vector<local_scalar_t__> CV;
      CV = std::vector<local_scalar_t__>(gamma_params, DUMMY_VAR__);
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= gamma_params; ++sym1__) {
        current_statement__ = 5;
        assign(CV, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable CV");}
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= gamma_params; ++sym1__) {
        current_statement__ = 5;
        if (jacobian__) {
          current_statement__ = 5;
          assign(CV, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(CV[(sym1__ - 1)], 0, lp__),
            "assigning variable CV");
        } else {
          current_statement__ = 5;
          assign(CV, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(CV[(sym1__ - 1)], 0),
            "assigning variable CV");
        }}
      std::vector<local_scalar_t__> nb2_phi;
      nb2_phi = std::vector<local_scalar_t__>(nb2_params, DUMMY_VAR__);
      
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= nb2_params; ++sym1__) {
        current_statement__ = 6;
        assign(nb2_phi, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable nb2_phi");}
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= nb2_params; ++sym1__) {
        current_statement__ = 6;
        if (jacobian__) {
          current_statement__ = 6;
          assign(nb2_phi, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(nb2_phi[(sym1__ - 1)], 0, lp__),
            "assigning variable nb2_phi");
        } else {
          current_statement__ = 6;
          assign(nb2_phi, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(nb2_phi[(sym1__ - 1)], 0),
            "assigning variable nb2_phi");
        }}
      std::vector<local_scalar_t__> yearEffects;
      yearEffects = std::vector<local_scalar_t__>(n_year_effects, DUMMY_VAR__);
      
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= n_year_effects; ++sym1__) {
        current_statement__ = 7;
        assign(yearEffects, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable yearEffects");}
      std::vector<local_scalar_t__> year_sigma;
      year_sigma = std::vector<local_scalar_t__>(est_temporalRE, DUMMY_VAR__);
      
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= est_temporalRE; ++sym1__) {
        current_statement__ = 8;
        assign(year_sigma, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable year_sigma");}
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= est_temporalRE; ++sym1__) {
        current_statement__ = 8;
        if (jacobian__) {
          current_statement__ = 8;
          assign(year_sigma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(year_sigma[(sym1__ - 1)], 0, lp__),
            "assigning variable year_sigma");
        } else {
          current_statement__ = 8;
          assign(year_sigma, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(year_sigma[(sym1__ - 1)], 0),
            "assigning variable year_sigma");
        }}
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> spatialEffectsKnots;
      spatialEffectsKnots = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(nT, Eigen::Matrix<local_scalar_t__, -1, 1>(nKnots));
      stan::math::fill(spatialEffectsKnots, DUMMY_VAR__);
      
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= nT; ++sym1__) {
        current_statement__ = 9;
        assign(spatialEffectsKnots,
          cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nKnots), "assigning variable spatialEffectsKnots");}
      Eigen::Matrix<local_scalar_t__, -1, 1> B;
      B = Eigen::Matrix<local_scalar_t__, -1, 1>(nCov);
      stan::math::fill(B, DUMMY_VAR__);
      
      current_statement__ = 10;
      B = in__.vector(nCov);
      std::vector<local_scalar_t__> phi;
      phi = std::vector<local_scalar_t__>(est_phi, DUMMY_VAR__);
      
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= est_phi; ++sym1__) {
        current_statement__ = 11;
        assign(phi, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable phi");}
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= est_phi; ++sym1__) {
        current_statement__ = 11;
        if (jacobian__) {
          current_statement__ = 11;
          assign(phi, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(phi[(sym1__ - 1)], -1, 1, lp__),
            "assigning variable phi");
        } else {
          current_statement__ = 11;
          assign(phi, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lub_constrain(phi[(sym1__ - 1)], -1, 1),
            "assigning variable phi");
        }}
      std::vector<local_scalar_t__> W;
      W = std::vector<local_scalar_t__>(nW, DUMMY_VAR__);
      
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= nW; ++sym1__) {
        current_statement__ = 12;
        assign(W, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable W");}
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= nW; ++sym1__) {
        current_statement__ = 12;
        if (jacobian__) {
          current_statement__ = 12;
          assign(W, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(W[(sym1__ - 1)], 0, lp__),
            "assigning variable W");
        } else {
          current_statement__ = 12;
          assign(W, cons_list(index_uni(sym1__), nil_index_list()),
            stan::math::lb_constrain(W[(sym1__ - 1)], 0),
            "assigning variable W");
        }}
      Eigen::Matrix<local_scalar_t__, -1, 1> muZeros;
      muZeros = Eigen::Matrix<local_scalar_t__, -1, 1>(nKnots);
      stan::math::fill(muZeros, DUMMY_VAR__);
      
      std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>> spatialEffects;
      spatialEffects = std::vector<Eigen::Matrix<local_scalar_t__, -1, 1>>(nT, Eigen::Matrix<local_scalar_t__, -1, 1>(nLocs));
      stan::math::fill(spatialEffects, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> SigmaKnots;
      SigmaKnots = Eigen::Matrix<local_scalar_t__, -1, -1>(nKnots, nKnots);
      stan::math::fill(SigmaKnots, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> transformed_dist;
      transformed_dist = Eigen::Matrix<local_scalar_t__, -1, -1>(nKnots, nKnots);
      stan::math::fill(transformed_dist, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> transformed_dist21;
      transformed_dist21 = Eigen::Matrix<local_scalar_t__, -1, -1>(nLocs, nKnots);
      stan::math::fill(transformed_dist21, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> SigmaOffDiag;
      SigmaOffDiag = Eigen::Matrix<local_scalar_t__, -1, -1>(nLocs, nKnots);
      stan::math::fill(SigmaOffDiag, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> SigmaOffDiagTemp;
      SigmaOffDiagTemp = Eigen::Matrix<local_scalar_t__, -1, -1>(nLocs, nKnots);
      stan::math::fill(SigmaOffDiagTemp, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, -1> invSigmaKnots;
      invSigmaKnots = Eigen::Matrix<local_scalar_t__, -1, -1>(nLocs, nKnots);
      stan::math::fill(invSigmaKnots, DUMMY_VAR__);
      
      Eigen::Matrix<local_scalar_t__, -1, 1> y_hat;
      y_hat = Eigen::Matrix<local_scalar_t__, -1, 1>(N);
      stan::math::fill(y_hat, DUMMY_VAR__);
      
      std::vector<local_scalar_t__> gammaA;
      gammaA = std::vector<local_scalar_t__>(gamma_params, DUMMY_VAR__);
      
      local_scalar_t__ gp_sigma_sq;
      gp_sigma_sq = DUMMY_VAR__;
      
      current_statement__ = 24;
      gp_sigma_sq = pow((gp_sigma * gp_sigma_scaling_factor), 2.0);
      current_statement__ = 28;
      if (logical_eq(cov_func, 0)) {
        current_statement__ = 25;
        assign(SigmaKnots, nil_index_list(),
          multiply(gp_sigma_sq,
            stan::math::exp(divide(minus(distKnots), gp_theta))),
          "assigning variable SigmaKnots");
        current_statement__ = 26;
        assign(SigmaOffDiagTemp, nil_index_list(),
          multiply(gp_sigma_sq,
            stan::math::exp(divide(minus(distKnots21), gp_theta))),
          "assigning variable SigmaOffDiagTemp");
      } 
      current_statement__ = 32;
      if (logical_eq(cov_func, 1)) {
        current_statement__ = 29;
        assign(SigmaKnots, nil_index_list(),
          multiply(gp_sigma_sq,
            stan::math::exp(
              multiply(-inv((2.0 * pow(gp_theta, 2.0))), distKnots))),
          "assigning variable SigmaKnots");
        current_statement__ = 30;
        assign(SigmaOffDiagTemp, nil_index_list(),
          multiply(gp_sigma_sq,
            stan::math::exp(
              multiply(-inv((2.0 * pow(gp_theta, 2.0))), distKnots21))),
          "assigning variable SigmaOffDiagTemp");
      } 
      current_statement__ = 46;
      if (logical_eq(cov_func, 2)) {
        current_statement__ = 38;
        if (logical_eq(matern_kappa, 1.5)) {
          current_statement__ = 33;
          assign(transformed_dist, nil_index_list(),
            divide(multiply(stan::math::sqrt(3.0), distKnots), gp_theta),
            "assigning variable transformed_dist");
          current_statement__ = 34;
          assign(SigmaKnots, nil_index_list(),
            elt_multiply(multiply(gp_sigma_sq, add(1.0, transformed_dist)),
              stan::math::exp(minus(transformed_dist))),
            "assigning variable SigmaKnots");
          current_statement__ = 35;
          assign(transformed_dist21, nil_index_list(),
            divide(multiply(stan::math::sqrt(3.0), distKnots21), gp_theta),
            "assigning variable transformed_dist21");
          current_statement__ = 36;
          assign(SigmaOffDiagTemp, nil_index_list(),
            elt_multiply(multiply(gp_sigma_sq, add(1.0, transformed_dist21)),
              stan::math::exp(minus(transformed_dist21))),
            "assigning variable SigmaOffDiagTemp");
        } 
        current_statement__ = 44;
        if (logical_eq(matern_kappa, 2.5)) {
          current_statement__ = 39;
          assign(transformed_dist, nil_index_list(),
            divide(multiply(stan::math::sqrt(5.0), distKnots), gp_theta),
            "assigning variable transformed_dist");
          current_statement__ = 40;
          assign(SigmaKnots, nil_index_list(),
            elt_multiply(
              multiply(gp_sigma_sq,
                add(add(1.0, transformed_dist),
                  divide(elt_multiply(transformed_dist, transformed_dist),
                    3.0))), stan::math::exp(minus(transformed_dist))),
            "assigning variable SigmaKnots");
          current_statement__ = 41;
          assign(transformed_dist21, nil_index_list(),
            divide(multiply(stan::math::sqrt(5.0), distKnots21), gp_theta),
            "assigning variable transformed_dist21");
          current_statement__ = 42;
          assign(SigmaOffDiagTemp, nil_index_list(),
            elt_multiply(
              multiply(gp_sigma_sq,
                add(add(1.0, transformed_dist21),
                  divide(
                    elt_multiply(transformed_dist21, transformed_dist21),
                    3.0))), stan::math::exp(minus(transformed_dist21))),
            "assigning variable SigmaOffDiagTemp");
        } 
      } 
      current_statement__ = 49;
      for (int k = 1; k <= nKnots; ++k) {
        current_statement__ = 47;
        assign(muZeros, cons_list(index_uni(k), nil_index_list()), 0,
          "assigning variable muZeros");}
      current_statement__ = 50;
      assign(SigmaOffDiag, nil_index_list(),
        multiply(SigmaOffDiagTemp, inverse_spd(SigmaKnots)),
        "assigning variable SigmaOffDiag");
      current_statement__ = 53;
      for (int t = 1; t <= nT; ++t) {
        current_statement__ = 51;
        assign(spatialEffects, cons_list(index_uni(t), nil_index_list()),
          multiply(SigmaOffDiag, spatialEffectsKnots[(t - 1)]),
          "assigning variable spatialEffects");}
      current_statement__ = 70;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 67;
        if (logical_eq(est_temporalRE, 0)) {
          current_statement__ = 65;
          if (logical_eq(fixed_intercept, 0)) {
            current_statement__ = 63;
            assign(y_hat, cons_list(index_uni(i), nil_index_list()),
              (multiply(
                 rvalue(X, cons_list(index_uni(i), nil_index_list()), "X"),
                 B) +
                spatialEffects[(yearID[(i - 1)] - 1)][(stationID[(i - 1)] -
                                                        1)]),
              "assigning variable y_hat");
          } else {
            current_statement__ = 61;
            assign(y_hat, cons_list(index_uni(i), nil_index_list()),
              spatialEffects[(yearID[(i - 1)] - 1)][(stationID[(i - 1)] - 1)],
              "assigning variable y_hat");
          }
        } else {
          current_statement__ = 56;
          if (logical_eq(nCov, 0)) {
            current_statement__ = 54;
            assign(y_hat, cons_list(index_uni(i), nil_index_list()),
              (spatialEffects[(yearID[(i - 1)] - 1)][(stationID[(i - 1)] - 1)]
                + yearEffects[(yearID[(i - 1)] - 1)]),
              "assigning variable y_hat");
          } 
          current_statement__ = 59;
          if (logical_gt(nCov, 0)) {
            current_statement__ = 57;
            assign(y_hat, cons_list(index_uni(i), nil_index_list()),
              ((multiply(
                  rvalue(X, cons_list(index_uni(i), nil_index_list()), "X"),
                  B) +
                 spatialEffects[(yearID[(i - 1)] - 1)][(stationID[(i - 1)] -
                                                         1)]) +
                yearEffects[(yearID[(i - 1)] - 1)]),
              "assigning variable y_hat");
          } 
        }
        current_statement__ = 68;
        assign(y_hat, cons_list(index_uni(i), nil_index_list()),
          (y_hat[(i - 1)] + input_offset[(i - 1)]),
          "assigning variable y_hat");}
      current_statement__ = 73;
      if (logical_eq(obs_model, 0)) {
        current_statement__ = 71;
        assign(gammaA, cons_list(index_uni(1), nil_index_list()),
          inv(pow(CV[(1 - 1)], 2.0)), "assigning variable gammaA");
      } 
      current_statement__ = 22;
      for (int sym1__ = 1; sym1__ <= gamma_params; ++sym1__) {
        current_statement__ = 22;
        current_statement__ = 22;
        check_greater_or_equal(function__, "gammaA[sym1__]",
                               gammaA[(sym1__ - 1)], 0);}
      current_statement__ = 23;
      current_statement__ = 23;
      check_greater_or_equal(function__, "gp_sigma_sq", gp_sigma_sq, 0);
      {
        current_statement__ = 99;
        lp_accum__.add(
          student_t_lpdf<propto__>(gp_theta, prior_gp_theta[(1 - 1)],
            prior_gp_theta[(2 - 1)], prior_gp_theta[(3 - 1)]));
        current_statement__ = 100;
        lp_accum__.add(
          student_t_lpdf<propto__>(gp_sigma, prior_gp_sigma[(1 - 1)],
            prior_gp_sigma[(2 - 1)], prior_gp_sigma[(3 - 1)]));
        current_statement__ = 103;
        if (logical_eq(est_phi, 1)) {
          current_statement__ = 101;
          lp_accum__.add(
            student_t_lpdf<propto__>(phi, prior_phi[(1 - 1)],
              prior_phi[(2 - 1)], prior_phi[(3 - 1)]));
        } 
        current_statement__ = 106;
        if (logical_gte(nCov, 1)) {
          current_statement__ = 104;
          lp_accum__.add(
            student_t_lpdf<propto__>(B[(1 - 1)], prior_intercept[(1 - 1)],
              prior_intercept[(2 - 1)], prior_intercept[(3 - 1)]));
        } 
        current_statement__ = 111;
        if (logical_gte(nCov, 2)) {
          current_statement__ = 109;
          for (int i = 2; i <= nCov; ++i) {
            current_statement__ = 107;
            lp_accum__.add(
              student_t_lpdf<propto__>(B[(i - 1)], prior_beta[(1 - 1)],
                prior_beta[(2 - 1)], prior_beta[(3 - 1)]));}
        } 
        current_statement__ = 118;
        if (logical_eq(est_temporalRE, 1)) {
          current_statement__ = 112;
          lp_accum__.add(
            student_t_lpdf<propto__>(year_sigma, prior_rw_sigma[(1 - 1)],
              prior_rw_sigma[(2 - 1)], prior_rw_sigma[(3 - 1)]));
          current_statement__ = 113;
          lp_accum__.add(
            student_t_lpdf<propto__>(yearEffects[(1 - 1)],
              prior_intercept[(1 - 1)], prior_intercept[(2 - 1)],
              prior_intercept[(3 - 1)]));
          current_statement__ = 116;
          for (int t = 2; t <= nT; ++t) {
            current_statement__ = 114;
            lp_accum__.add(
              normal_lpdf<propto__>(yearEffects[(t - 1)],
                yearEffects[((t - 1) - 1)], year_sigma));}
        } 
        current_statement__ = 126;
        if (logical_eq(est_df, 1)) {
          current_statement__ = 123;
          lp_accum__.add(
            scaled_inv_chi_square_lpdf<propto__>(W, df[(1 - 1)], 1));
          current_statement__ = 124;
          lp_accum__.add(gamma_lpdf<propto__>(df, 2, 0.1));
        } else {
          current_statement__ = 121;
          if (logical_gt(nW, 0)) {
            current_statement__ = 119;
            lp_accum__.add(
              scaled_inv_chi_square_lpdf<propto__>(W, fixed_df_value, 1));
          } 
        }
        current_statement__ = 145;
        if (logical_gt(nW, 0)) {
          current_statement__ = 136;
          lp_accum__.add(
            multi_normal_lpdf<propto__>(spatialEffectsKnots[(1 - 1)],
              muZeros, multiply(W[(1 - 1)], SigmaKnots)));
          current_statement__ = 143;
          for (int t = 2; t <= nT; ++t) {
            current_statement__ = 141;
            if (logical_eq(est_phi, 1)) {
              current_statement__ = 139;
              lp_accum__.add(
                multi_normal_lpdf<propto__>(spatialEffectsKnots[(t - 1)],
                  multiply(phi[(1 - 1)], spatialEffectsKnots[((t - 1) - 1)]),
                  multiply(W[(t - 1)], SigmaKnots)));
            } else {
              current_statement__ = 137;
              lp_accum__.add(
                multi_normal_lpdf<propto__>(spatialEffectsKnots[(t - 1)],
                  multiply(fixed_phi_value,
                    spatialEffectsKnots[((t - 1) - 1)]),
                  multiply(W[(t - 1)], SigmaKnots)));
            }}
        } else {
          current_statement__ = 127;
          lp_accum__.add(
            multi_normal_lpdf<propto__>(spatialEffectsKnots[(1 - 1)],
              muZeros, SigmaKnots));
          current_statement__ = 134;
          for (int t = 2; t <= nT; ++t) {
            current_statement__ = 132;
            if (logical_eq(est_phi, 1)) {
              current_statement__ = 130;
              lp_accum__.add(
                multi_normal_lpdf<propto__>(spatialEffectsKnots[(t - 1)],
                  multiply(phi[(1 - 1)], spatialEffectsKnots[((t - 1) - 1)]),
                  SigmaKnots));
            } else {
              current_statement__ = 128;
              lp_accum__.add(
                multi_normal_lpdf<propto__>(spatialEffectsKnots[(t - 1)],
                  multiply(fixed_phi_value,
                    spatialEffectsKnots[((t - 1) - 1)]), SigmaKnots));
            }}
        }
        current_statement__ = 149;
        if (logical_eq(obs_model, 0)) {
          current_statement__ = 146;
          lp_accum__.add(
            student_t_lpdf<propto__>(CV[(1 - 1)], prior_sigma[(1 - 1)],
              prior_sigma[(2 - 1)], prior_sigma[(3 - 1)]));
          current_statement__ = 147;
          lp_accum__.add(
            gamma_lpdf<propto__>(y, gammaA[(1 - 1)],
              elt_divide(gammaA[(1 - 1)], stan::math::exp(y_hat))));
        } 
        current_statement__ = 153;
        if (logical_eq(obs_model, 1)) {
          current_statement__ = 150;
          lp_accum__.add(
            student_t_lpdf<propto__>(sigma[(1 - 1)], prior_sigma[(1 - 1)],
              prior_sigma[(2 - 1)], prior_sigma[(3 - 1)]));
          current_statement__ = 151;
          lp_accum__.add(normal_lpdf<propto__>(y, y_hat, sigma[(1 - 1)]));
        } 
        current_statement__ = 164;
        if (logical_eq(obs_model, 2)) {
          current_statement__ = 154;
          lp_accum__.add(
            student_t_lpdf<propto__>(nb2_phi[(1 - 1)], prior_sigma[(1 - 1)],
              prior_sigma[(2 - 1)], prior_sigma[(3 - 1)]));
          current_statement__ = 162;
          if (logical_eq(lower_truncation, 0)) {
            current_statement__ = 160;
            lp_accum__.add(
              neg_binomial_2_log_lpmf<propto__>(y_int, y_hat,
                nb2_phi[(1 - 1)]));
          } else {
            current_statement__ = 158;
            for (int i = 1; i <= N; ++i) {
              current_statement__ = 155;
              if (logical_lt(y_int[(i - 1)], lower_truncation)) {
                current_statement__ = 155;
                lp_accum__.add(stan::math::negative_infinity());
              } else {
                current_statement__ = 155;
                lp_accum__.add(
                  -neg_binomial_2_ccdf_log((lower_truncation - 1),
                     stan::math::exp(y_hat[(i - 1)]), nb2_phi[(1 - 1)]));
              }
              current_statement__ = 156;
              lp_accum__.add(
                neg_binomial_2_lpmf<propto__>(y_int[(i - 1)],
                  stan::math::exp(y_hat[(i - 1)]), nb2_phi[(1 - 1)]));}
          }
        } 
        current_statement__ = 167;
        if (logical_eq(obs_model, 4)) {
          current_statement__ = 165;
          lp_accum__.add(
            binomial_logit_lpmf<propto__>(y_int, binomialN, y_hat));
        } 
        current_statement__ = 170;
        if (logical_eq(obs_model, 5)) {
          current_statement__ = 168;
          lp_accum__.add(poisson_log_lpmf<propto__>(y_int, y_hat));
        } 
        current_statement__ = 174;
        if (logical_eq(obs_model, 6)) {
          current_statement__ = 171;
          lp_accum__.add(
            student_t_lpdf<propto__>(sigma[(1 - 1)], prior_sigma[(1 - 1)],
              prior_sigma[(2 - 1)], prior_sigma[(3 - 1)]));
          current_statement__ = 172;
          lp_accum__.add(lognormal_lpdf<propto__>(y, y_hat, sigma[(1 - 1)]));
        } 
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_glmmfields_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      double gp_theta;
      gp_theta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 1;
      gp_theta = in__.scalar();
      current_statement__ = 1;
      gp_theta = stan::math::lb_constrain(gp_theta, 0);
      double gp_sigma;
      gp_sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      gp_sigma = in__.scalar();
      current_statement__ = 2;
      gp_sigma = stan::math::lb_constrain(gp_sigma, 0);
      std::vector<double> df;
      df = std::vector<double>(est_df, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= est_df; ++sym1__) {
        current_statement__ = 3;
        assign(df, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable df");}
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= est_df; ++sym1__) {
        current_statement__ = 3;
        assign(df, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(df[(sym1__ - 1)], df_lower_bound),
          "assigning variable df");}
      std::vector<double> sigma;
      sigma = std::vector<double>(norm_params, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= norm_params; ++sym1__) {
        current_statement__ = 4;
        assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable sigma");}
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= norm_params; ++sym1__) {
        current_statement__ = 4;
        assign(sigma, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(sigma[(sym1__ - 1)], 0),
          "assigning variable sigma");}
      std::vector<double> CV;
      CV = std::vector<double>(gamma_params, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= gamma_params; ++sym1__) {
        current_statement__ = 5;
        assign(CV, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable CV");}
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= gamma_params; ++sym1__) {
        current_statement__ = 5;
        assign(CV, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(CV[(sym1__ - 1)], 0),
          "assigning variable CV");}
      std::vector<double> nb2_phi;
      nb2_phi = std::vector<double>(nb2_params, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= nb2_params; ++sym1__) {
        current_statement__ = 6;
        assign(nb2_phi, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable nb2_phi");}
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= nb2_params; ++sym1__) {
        current_statement__ = 6;
        assign(nb2_phi, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(nb2_phi[(sym1__ - 1)], 0),
          "assigning variable nb2_phi");}
      std::vector<double> yearEffects;
      yearEffects = std::vector<double>(n_year_effects, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      for (int sym1__ = 1; sym1__ <= n_year_effects; ++sym1__) {
        current_statement__ = 7;
        assign(yearEffects, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable yearEffects");}
      std::vector<double> year_sigma;
      year_sigma = std::vector<double>(est_temporalRE, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= est_temporalRE; ++sym1__) {
        current_statement__ = 8;
        assign(year_sigma, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable year_sigma");}
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= est_temporalRE; ++sym1__) {
        current_statement__ = 8;
        assign(year_sigma, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(year_sigma[(sym1__ - 1)], 0),
          "assigning variable year_sigma");}
      std::vector<Eigen::Matrix<double, -1, 1>> spatialEffectsKnots;
      spatialEffectsKnots = std::vector<Eigen::Matrix<double, -1, 1>>(nT, Eigen::Matrix<double, -1, 1>(nKnots));
      stan::math::fill(spatialEffectsKnots, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 9;
      for (int sym1__ = 1; sym1__ <= nT; ++sym1__) {
        current_statement__ = 9;
        assign(spatialEffectsKnots,
          cons_list(index_uni(sym1__), nil_index_list()),
          in__.vector(nKnots), "assigning variable spatialEffectsKnots");}
      Eigen::Matrix<double, -1, 1> B;
      B = Eigen::Matrix<double, -1, 1>(nCov);
      stan::math::fill(B, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 10;
      B = in__.vector(nCov);
      std::vector<double> phi;
      phi = std::vector<double>(est_phi, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= est_phi; ++sym1__) {
        current_statement__ = 11;
        assign(phi, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable phi");}
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= est_phi; ++sym1__) {
        current_statement__ = 11;
        assign(phi, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_constrain(phi[(sym1__ - 1)], -1, 1),
          "assigning variable phi");}
      std::vector<double> W;
      W = std::vector<double>(nW, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= nW; ++sym1__) {
        current_statement__ = 12;
        assign(W, cons_list(index_uni(sym1__), nil_index_list()),
          in__.scalar(), "assigning variable W");}
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= nW; ++sym1__) {
        current_statement__ = 12;
        assign(W, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_constrain(W[(sym1__ - 1)], 0),
          "assigning variable W");}
      Eigen::Matrix<double, -1, 1> muZeros;
      muZeros = Eigen::Matrix<double, -1, 1>(nKnots);
      stan::math::fill(muZeros, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<Eigen::Matrix<double, -1, 1>> spatialEffects;
      spatialEffects = std::vector<Eigen::Matrix<double, -1, 1>>(nT, Eigen::Matrix<double, -1, 1>(nLocs));
      stan::math::fill(spatialEffects, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> SigmaKnots;
      SigmaKnots = Eigen::Matrix<double, -1, -1>(nKnots, nKnots);
      stan::math::fill(SigmaKnots, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> transformed_dist;
      transformed_dist = Eigen::Matrix<double, -1, -1>(nKnots, nKnots);
      stan::math::fill(transformed_dist, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> transformed_dist21;
      transformed_dist21 = Eigen::Matrix<double, -1, -1>(nLocs, nKnots);
      stan::math::fill(transformed_dist21, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> SigmaOffDiag;
      SigmaOffDiag = Eigen::Matrix<double, -1, -1>(nLocs, nKnots);
      stan::math::fill(SigmaOffDiag, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> SigmaOffDiagTemp;
      SigmaOffDiagTemp = Eigen::Matrix<double, -1, -1>(nLocs, nKnots);
      stan::math::fill(SigmaOffDiagTemp, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, -1> invSigmaKnots;
      invSigmaKnots = Eigen::Matrix<double, -1, -1>(nLocs, nKnots);
      stan::math::fill(invSigmaKnots, std::numeric_limits<double>::quiet_NaN());
      
      Eigen::Matrix<double, -1, 1> y_hat;
      y_hat = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(y_hat, std::numeric_limits<double>::quiet_NaN());
      
      std::vector<double> gammaA;
      gammaA = std::vector<double>(gamma_params, std::numeric_limits<double>::quiet_NaN());
      
      double gp_sigma_sq;
      gp_sigma_sq = std::numeric_limits<double>::quiet_NaN();
      
      vars__.emplace_back(gp_theta);
      vars__.emplace_back(gp_sigma);
      for (int sym1__ = 1; sym1__ <= est_df; ++sym1__) {
        vars__.emplace_back(df[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= norm_params; ++sym1__) {
        vars__.emplace_back(sigma[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= gamma_params; ++sym1__) {
        vars__.emplace_back(CV[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nb2_params; ++sym1__) {
        vars__.emplace_back(nb2_phi[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= n_year_effects; ++sym1__) {
        vars__.emplace_back(yearEffects[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= est_temporalRE; ++sym1__) {
        vars__.emplace_back(year_sigma[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nT; ++sym2__) {
          vars__.emplace_back(
            spatialEffectsKnots[(sym2__ - 1)][(sym1__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nCov; ++sym1__) {
        vars__.emplace_back(B[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= est_phi; ++sym1__) {
        vars__.emplace_back(phi[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nW; ++sym1__) {
        vars__.emplace_back(W[(sym1__ - 1)]);}
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 24;
      gp_sigma_sq = pow((gp_sigma * gp_sigma_scaling_factor), 2.0);
      current_statement__ = 28;
      if (logical_eq(cov_func, 0)) {
        current_statement__ = 25;
        assign(SigmaKnots, nil_index_list(),
          multiply(gp_sigma_sq,
            stan::math::exp(divide(minus(distKnots), gp_theta))),
          "assigning variable SigmaKnots");
        current_statement__ = 26;
        assign(SigmaOffDiagTemp, nil_index_list(),
          multiply(gp_sigma_sq,
            stan::math::exp(divide(minus(distKnots21), gp_theta))),
          "assigning variable SigmaOffDiagTemp");
      } 
      current_statement__ = 32;
      if (logical_eq(cov_func, 1)) {
        current_statement__ = 29;
        assign(SigmaKnots, nil_index_list(),
          multiply(gp_sigma_sq,
            stan::math::exp(
              multiply(-inv((2.0 * pow(gp_theta, 2.0))), distKnots))),
          "assigning variable SigmaKnots");
        current_statement__ = 30;
        assign(SigmaOffDiagTemp, nil_index_list(),
          multiply(gp_sigma_sq,
            stan::math::exp(
              multiply(-inv((2.0 * pow(gp_theta, 2.0))), distKnots21))),
          "assigning variable SigmaOffDiagTemp");
      } 
      current_statement__ = 46;
      if (logical_eq(cov_func, 2)) {
        current_statement__ = 38;
        if (logical_eq(matern_kappa, 1.5)) {
          current_statement__ = 33;
          assign(transformed_dist, nil_index_list(),
            divide(multiply(stan::math::sqrt(3.0), distKnots), gp_theta),
            "assigning variable transformed_dist");
          current_statement__ = 34;
          assign(SigmaKnots, nil_index_list(),
            elt_multiply(multiply(gp_sigma_sq, add(1.0, transformed_dist)),
              stan::math::exp(minus(transformed_dist))),
            "assigning variable SigmaKnots");
          current_statement__ = 35;
          assign(transformed_dist21, nil_index_list(),
            divide(multiply(stan::math::sqrt(3.0), distKnots21), gp_theta),
            "assigning variable transformed_dist21");
          current_statement__ = 36;
          assign(SigmaOffDiagTemp, nil_index_list(),
            elt_multiply(multiply(gp_sigma_sq, add(1.0, transformed_dist21)),
              stan::math::exp(minus(transformed_dist21))),
            "assigning variable SigmaOffDiagTemp");
        } 
        current_statement__ = 44;
        if (logical_eq(matern_kappa, 2.5)) {
          current_statement__ = 39;
          assign(transformed_dist, nil_index_list(),
            divide(multiply(stan::math::sqrt(5.0), distKnots), gp_theta),
            "assigning variable transformed_dist");
          current_statement__ = 40;
          assign(SigmaKnots, nil_index_list(),
            elt_multiply(
              multiply(gp_sigma_sq,
                add(add(1.0, transformed_dist),
                  divide(elt_multiply(transformed_dist, transformed_dist),
                    3.0))), stan::math::exp(minus(transformed_dist))),
            "assigning variable SigmaKnots");
          current_statement__ = 41;
          assign(transformed_dist21, nil_index_list(),
            divide(multiply(stan::math::sqrt(5.0), distKnots21), gp_theta),
            "assigning variable transformed_dist21");
          current_statement__ = 42;
          assign(SigmaOffDiagTemp, nil_index_list(),
            elt_multiply(
              multiply(gp_sigma_sq,
                add(add(1.0, transformed_dist21),
                  divide(
                    elt_multiply(transformed_dist21, transformed_dist21),
                    3.0))), stan::math::exp(minus(transformed_dist21))),
            "assigning variable SigmaOffDiagTemp");
        } 
      } 
      current_statement__ = 49;
      for (int k = 1; k <= nKnots; ++k) {
        current_statement__ = 47;
        assign(muZeros, cons_list(index_uni(k), nil_index_list()), 0,
          "assigning variable muZeros");}
      current_statement__ = 50;
      assign(SigmaOffDiag, nil_index_list(),
        multiply(SigmaOffDiagTemp, inverse_spd(SigmaKnots)),
        "assigning variable SigmaOffDiag");
      current_statement__ = 53;
      for (int t = 1; t <= nT; ++t) {
        current_statement__ = 51;
        assign(spatialEffects, cons_list(index_uni(t), nil_index_list()),
          multiply(SigmaOffDiag, spatialEffectsKnots[(t - 1)]),
          "assigning variable spatialEffects");}
      current_statement__ = 70;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 67;
        if (logical_eq(est_temporalRE, 0)) {
          current_statement__ = 65;
          if (logical_eq(fixed_intercept, 0)) {
            current_statement__ = 63;
            assign(y_hat, cons_list(index_uni(i), nil_index_list()),
              (multiply(
                 rvalue(X, cons_list(index_uni(i), nil_index_list()), "X"),
                 B) +
                spatialEffects[(yearID[(i - 1)] - 1)][(stationID[(i - 1)] -
                                                        1)]),
              "assigning variable y_hat");
          } else {
            current_statement__ = 61;
            assign(y_hat, cons_list(index_uni(i), nil_index_list()),
              spatialEffects[(yearID[(i - 1)] - 1)][(stationID[(i - 1)] - 1)],
              "assigning variable y_hat");
          }
        } else {
          current_statement__ = 56;
          if (logical_eq(nCov, 0)) {
            current_statement__ = 54;
            assign(y_hat, cons_list(index_uni(i), nil_index_list()),
              (spatialEffects[(yearID[(i - 1)] - 1)][(stationID[(i - 1)] - 1)]
                + yearEffects[(yearID[(i - 1)] - 1)]),
              "assigning variable y_hat");
          } 
          current_statement__ = 59;
          if (logical_gt(nCov, 0)) {
            current_statement__ = 57;
            assign(y_hat, cons_list(index_uni(i), nil_index_list()),
              ((multiply(
                  rvalue(X, cons_list(index_uni(i), nil_index_list()), "X"),
                  B) +
                 spatialEffects[(yearID[(i - 1)] - 1)][(stationID[(i - 1)] -
                                                         1)]) +
                yearEffects[(yearID[(i - 1)] - 1)]),
              "assigning variable y_hat");
          } 
        }
        current_statement__ = 68;
        assign(y_hat, cons_list(index_uni(i), nil_index_list()),
          (y_hat[(i - 1)] + input_offset[(i - 1)]),
          "assigning variable y_hat");}
      current_statement__ = 73;
      if (logical_eq(obs_model, 0)) {
        current_statement__ = 71;
        assign(gammaA, cons_list(index_uni(1), nil_index_list()),
          inv(pow(CV[(1 - 1)], 2.0)), "assigning variable gammaA");
      } 
      current_statement__ = 22;
      for (int sym1__ = 1; sym1__ <= gamma_params; ++sym1__) {
        current_statement__ = 22;
        current_statement__ = 22;
        check_greater_or_equal(function__, "gammaA[sym1__]",
                               gammaA[(sym1__ - 1)], 0);}
      current_statement__ = 23;
      current_statement__ = 23;
      check_greater_or_equal(function__, "gp_sigma_sq", gp_sigma_sq, 0);
      if (emit_transformed_parameters__) {
        for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
          vars__.emplace_back(muZeros[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= nLocs; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= nT; ++sym2__) {
            vars__.emplace_back(spatialEffects[(sym2__ - 1)][(sym1__ - 1)]);}
        }
        for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= nKnots; ++sym2__) {
            vars__.emplace_back(
              rvalue(SigmaKnots,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())),
                "SigmaKnots"));}}
        for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= nKnots; ++sym2__) {
            vars__.emplace_back(
              rvalue(transformed_dist,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())),
                "transformed_dist"));}}
        for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= nLocs; ++sym2__) {
            vars__.emplace_back(
              rvalue(transformed_dist21,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())),
                "transformed_dist21"));}}
        for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= nLocs; ++sym2__) {
            vars__.emplace_back(
              rvalue(SigmaOffDiag,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())),
                "SigmaOffDiag"));}}
        for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= nLocs; ++sym2__) {
            vars__.emplace_back(
              rvalue(SigmaOffDiagTemp,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())),
                "SigmaOffDiagTemp"));}}
        for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
          for (int sym2__ = 1; sym2__ <= nLocs; ++sym2__) {
            vars__.emplace_back(
              rvalue(invSigmaKnots,
                cons_list(index_uni(sym2__),
                  cons_list(index_uni(sym1__), nil_index_list())),
                "invSigmaKnots"));}}
        for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
          vars__.emplace_back(y_hat[(sym1__ - 1)]);}
        for (int sym1__ = 1; sym1__ <= gamma_params; ++sym1__) {
          vars__.emplace_back(gammaA[(sym1__ - 1)]);}
        vars__.emplace_back(gp_sigma_sq);
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
      Eigen::Matrix<double, -1, 1> log_lik;
      log_lik = Eigen::Matrix<double, -1, 1>(N);
      stan::math::fill(log_lik, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 98;
      for (int i = 1; i <= N; ++i) {
        current_statement__ = 77;
        if (logical_eq(obs_model, 0)) {
          current_statement__ = 75;
          assign(log_lik, cons_list(index_uni(i), nil_index_list()),
            gamma_lpdf<false>(y[(i - 1)], gammaA[(1 - 1)],
              (gammaA[(1 - 1)] / stan::math::exp(y_hat[(i - 1)]))),
            "assigning variable log_lik");
        } 
        current_statement__ = 80;
        if (logical_eq(obs_model, 1)) {
          current_statement__ = 78;
          assign(log_lik, cons_list(index_uni(i), nil_index_list()),
            normal_lpdf<false>(y[(i - 1)], y_hat[(i - 1)], sigma[(1 - 1)]),
            "assigning variable log_lik");
        } 
        current_statement__ = 87;
        if (logical_eq(obs_model, 2)) {
          current_statement__ = 85;
          if (logical_eq(lower_truncation, 0)) {
            current_statement__ = 83;
            assign(log_lik, cons_list(index_uni(i), nil_index_list()),
              neg_binomial_2_log_lpmf<false>(y_int[(i - 1)], y_hat[(i - 1)],
                nb2_phi[(1 - 1)]), "assigning variable log_lik");
          } else {
            current_statement__ = 81;
            assign(log_lik, cons_list(index_uni(i), nil_index_list()),
              neg_binomial_2_lpmf<false>(y_int[(i - 1)],
                stan::math::exp(y_hat[(i - 1)]), nb2_phi[(1 - 1)]),
              "assigning variable log_lik");
          }
        } 
        current_statement__ = 90;
        if (logical_eq(obs_model, 4)) {
          current_statement__ = 88;
          assign(log_lik, cons_list(index_uni(i), nil_index_list()),
            binomial_logit_lpmf<false>(y_int[(i - 1)], binomialN[(i - 1)],
              y_hat[(i - 1)]), "assigning variable log_lik");
        } 
        current_statement__ = 93;
        if (logical_eq(obs_model, 5)) {
          current_statement__ = 91;
          assign(log_lik, cons_list(index_uni(i), nil_index_list()),
            poisson_log_lpmf<false>(y_int[(i - 1)], y_hat[(i - 1)]),
            "assigning variable log_lik");
        } 
        current_statement__ = 96;
        if (logical_eq(obs_model, 6)) {
          current_statement__ = 94;
          assign(log_lik, cons_list(index_uni(i), nil_index_list()),
            lognormal_lpdf<false>(y[(i - 1)], y_hat, sigma[(1 - 1)]),
            "assigning variable log_lik");
        } }
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        vars__.emplace_back(log_lik[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      double gp_theta;
      gp_theta = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 1;
      gp_theta = context__.vals_r("gp_theta")[(1 - 1)];
      double gp_theta_free__;
      gp_theta_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 1;
      gp_theta_free__ = stan::math::lb_free(gp_theta, 0);
      double gp_sigma;
      gp_sigma = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      gp_sigma = context__.vals_r("gp_sigma")[(1 - 1)];
      double gp_sigma_free__;
      gp_sigma_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      gp_sigma_free__ = stan::math::lb_free(gp_sigma, 0);
      std::vector<double> df;
      df = std::vector<double>(est_df, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      assign(df, nil_index_list(), context__.vals_r("df"),
        "assigning variable df");
      std::vector<double> df_free__;
      df_free__ = std::vector<double>(est_df, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 3;
      for (int sym1__ = 1; sym1__ <= est_df; ++sym1__) {
        current_statement__ = 3;
        assign(df_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(df[(sym1__ - 1)], df_lower_bound),
          "assigning variable df_free__");}
      std::vector<double> sigma;
      sigma = std::vector<double>(norm_params, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      assign(sigma, nil_index_list(), context__.vals_r("sigma"),
        "assigning variable sigma");
      std::vector<double> sigma_free__;
      sigma_free__ = std::vector<double>(norm_params, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 4;
      for (int sym1__ = 1; sym1__ <= norm_params; ++sym1__) {
        current_statement__ = 4;
        assign(sigma_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(sigma[(sym1__ - 1)], 0),
          "assigning variable sigma_free__");}
      std::vector<double> CV;
      CV = std::vector<double>(gamma_params, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      assign(CV, nil_index_list(), context__.vals_r("CV"),
        "assigning variable CV");
      std::vector<double> CV_free__;
      CV_free__ = std::vector<double>(gamma_params, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 5;
      for (int sym1__ = 1; sym1__ <= gamma_params; ++sym1__) {
        current_statement__ = 5;
        assign(CV_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(CV[(sym1__ - 1)], 0),
          "assigning variable CV_free__");}
      std::vector<double> nb2_phi;
      nb2_phi = std::vector<double>(nb2_params, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      assign(nb2_phi, nil_index_list(), context__.vals_r("nb2_phi"),
        "assigning variable nb2_phi");
      std::vector<double> nb2_phi_free__;
      nb2_phi_free__ = std::vector<double>(nb2_params, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 6;
      for (int sym1__ = 1; sym1__ <= nb2_params; ++sym1__) {
        current_statement__ = 6;
        assign(nb2_phi_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(nb2_phi[(sym1__ - 1)], 0),
          "assigning variable nb2_phi_free__");}
      std::vector<double> yearEffects;
      yearEffects = std::vector<double>(n_year_effects, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 7;
      assign(yearEffects, nil_index_list(), context__.vals_r("yearEffects"),
        "assigning variable yearEffects");
      std::vector<double> year_sigma;
      year_sigma = std::vector<double>(est_temporalRE, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 8;
      assign(year_sigma, nil_index_list(), context__.vals_r("year_sigma"),
        "assigning variable year_sigma");
      std::vector<double> year_sigma_free__;
      year_sigma_free__ = std::vector<double>(est_temporalRE, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 8;
      for (int sym1__ = 1; sym1__ <= est_temporalRE; ++sym1__) {
        current_statement__ = 8;
        assign(year_sigma_free__,
          cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(year_sigma[(sym1__ - 1)], 0),
          "assigning variable year_sigma_free__");}
      std::vector<Eigen::Matrix<double, -1, 1>> spatialEffectsKnots;
      spatialEffectsKnots = std::vector<Eigen::Matrix<double, -1, 1>>(nT, Eigen::Matrix<double, -1, 1>(nKnots));
      stan::math::fill(spatialEffectsKnots, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> spatialEffectsKnots_flat__;
        current_statement__ = 9;
        assign(spatialEffectsKnots_flat__, nil_index_list(),
          context__.vals_r("spatialEffectsKnots"),
          "assigning variable spatialEffectsKnots_flat__");
        current_statement__ = 9;
        pos__ = 1;
        current_statement__ = 9;
        for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
          current_statement__ = 9;
          for (int sym2__ = 1; sym2__ <= nT; ++sym2__) {
            current_statement__ = 9;
            assign(spatialEffectsKnots,
              cons_list(index_uni(sym2__),
                cons_list(index_uni(sym1__), nil_index_list())),
              spatialEffectsKnots_flat__[(pos__ - 1)],
              "assigning variable spatialEffectsKnots");
            current_statement__ = 9;
            pos__ = (pos__ + 1);}}
      }
      Eigen::Matrix<double, -1, 1> B;
      B = Eigen::Matrix<double, -1, 1>(nCov);
      stan::math::fill(B, std::numeric_limits<double>::quiet_NaN());
      
      {
        std::vector<local_scalar_t__> B_flat__;
        current_statement__ = 10;
        assign(B_flat__, nil_index_list(), context__.vals_r("B"),
          "assigning variable B_flat__");
        current_statement__ = 10;
        pos__ = 1;
        current_statement__ = 10;
        for (int sym1__ = 1; sym1__ <= nCov; ++sym1__) {
          current_statement__ = 10;
          assign(B, cons_list(index_uni(sym1__), nil_index_list()),
            B_flat__[(pos__ - 1)], "assigning variable B");
          current_statement__ = 10;
          pos__ = (pos__ + 1);}
      }
      std::vector<double> phi;
      phi = std::vector<double>(est_phi, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 11;
      assign(phi, nil_index_list(), context__.vals_r("phi"),
        "assigning variable phi");
      std::vector<double> phi_free__;
      phi_free__ = std::vector<double>(est_phi, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 11;
      for (int sym1__ = 1; sym1__ <= est_phi; ++sym1__) {
        current_statement__ = 11;
        assign(phi_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lub_free(phi[(sym1__ - 1)], -1, 1),
          "assigning variable phi_free__");}
      std::vector<double> W;
      W = std::vector<double>(nW, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 12;
      assign(W, nil_index_list(), context__.vals_r("W"),
        "assigning variable W");
      std::vector<double> W_free__;
      W_free__ = std::vector<double>(nW, std::numeric_limits<double>::quiet_NaN());
      
      current_statement__ = 12;
      for (int sym1__ = 1; sym1__ <= nW; ++sym1__) {
        current_statement__ = 12;
        assign(W_free__, cons_list(index_uni(sym1__), nil_index_list()),
          stan::math::lb_free(W[(sym1__ - 1)], 0),
          "assigning variable W_free__");}
      vars__.emplace_back(gp_theta_free__);
      vars__.emplace_back(gp_sigma_free__);
      for (int sym1__ = 1; sym1__ <= est_df; ++sym1__) {
        vars__.emplace_back(df_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= norm_params; ++sym1__) {
        vars__.emplace_back(sigma_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= gamma_params; ++sym1__) {
        vars__.emplace_back(CV_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nb2_params; ++sym1__) {
        vars__.emplace_back(nb2_phi_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= n_year_effects; ++sym1__) {
        vars__.emplace_back(yearEffects[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= est_temporalRE; ++sym1__) {
        vars__.emplace_back(year_sigma_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nT; ++sym1__) {
        for (int sym2__ = 1; sym2__ <= nKnots; ++sym2__) {
          vars__.emplace_back(
            spatialEffectsKnots[(sym1__ - 1)][(sym2__ - 1)]);}}
      for (int sym1__ = 1; sym1__ <= nCov; ++sym1__) {
        vars__.emplace_back(B[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= est_phi; ++sym1__) {
        vars__.emplace_back(phi_free__[(sym1__ - 1)]);}
      for (int sym1__ = 1; sym1__ <= nW; ++sym1__) {
        vars__.emplace_back(W_free__[(sym1__ - 1)]);}
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("gp_theta");
    names__.emplace_back("gp_sigma");
    names__.emplace_back("df");
    names__.emplace_back("sigma");
    names__.emplace_back("CV");
    names__.emplace_back("nb2_phi");
    names__.emplace_back("yearEffects");
    names__.emplace_back("year_sigma");
    names__.emplace_back("spatialEffectsKnots");
    names__.emplace_back("B");
    names__.emplace_back("phi");
    names__.emplace_back("W");
    names__.emplace_back("muZeros");
    names__.emplace_back("spatialEffects");
    names__.emplace_back("SigmaKnots");
    names__.emplace_back("transformed_dist");
    names__.emplace_back("transformed_dist21");
    names__.emplace_back("SigmaOffDiag");
    names__.emplace_back("SigmaOffDiagTemp");
    names__.emplace_back("invSigmaKnots");
    names__.emplace_back("y_hat");
    names__.emplace_back("gammaA");
    names__.emplace_back("gp_sigma_sq");
    names__.emplace_back("log_lik");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(est_df)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(norm_params)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(gamma_params)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nb2_params)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(n_year_effects)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(est_temporalRE)
                                             });
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nT),
                                             static_cast<size_t>(nKnots)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nCov)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(est_phi)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nW)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nKnots)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nT),
                                             static_cast<size_t>(nLocs)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nKnots),
                                             static_cast<size_t>(nKnots)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nKnots),
                                             static_cast<size_t>(nKnots)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nLocs),
                                             static_cast<size_t>(nKnots)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nLocs),
                                             static_cast<size_t>(nKnots)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nLocs),
                                             static_cast<size_t>(nKnots)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(nLocs),
                                             static_cast<size_t>(nKnots)});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    dimss__.emplace_back(std::vector<size_t>{
                                             static_cast<size_t>(gamma_params)});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{static_cast<size_t>(N)});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    param_names__.emplace_back(std::string() + "gp_theta");
    param_names__.emplace_back(std::string() + "gp_sigma");
    for (int sym1__ = 1; sym1__ <= est_df; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "df" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= norm_params; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= gamma_params; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "CV" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nb2_params; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "nb2_phi" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= n_year_effects; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "yearEffects" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= est_temporalRE; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "year_sigma" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nT; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "spatialEffectsKnots" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nCov; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "B" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= est_phi; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "phi" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nW; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "W" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "muZeros" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nLocs; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nT; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "spatialEffects" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nKnots; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "SigmaKnots" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nKnots; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "transformed_dist" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nLocs; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "transformed_dist21" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nLocs; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "SigmaOffDiag" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nLocs; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "SigmaOffDiagTemp" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nLocs; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "invSigmaKnots" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "y_hat" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= gamma_params; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "gammaA" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "gp_sigma_sq");
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    param_names__.emplace_back(std::string() + "gp_theta");
    param_names__.emplace_back(std::string() + "gp_sigma");
    for (int sym1__ = 1; sym1__ <= est_df; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "df" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= norm_params; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "sigma" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= gamma_params; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "CV" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nb2_params; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "nb2_phi" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= n_year_effects; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "yearEffects" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= est_temporalRE; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "year_sigma" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
      {
        for (int sym2__ = 1; sym2__ <= nT; ++sym2__) {
          {
            param_names__.emplace_back(std::string() + "spatialEffectsKnots" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
          }}
      }}
    for (int sym1__ = 1; sym1__ <= nCov; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "B" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= est_phi; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "phi" + '.' + std::to_string(sym1__));
      }}
    for (int sym1__ = 1; sym1__ <= nW; ++sym1__) {
      {
        param_names__.emplace_back(std::string() + "W" + '.' + std::to_string(sym1__));
      }}
    if (emit_transformed_parameters__) {
      for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "muZeros" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= nLocs; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nT; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "spatialEffects" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nKnots; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "SigmaKnots" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nKnots; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "transformed_dist" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nLocs; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "transformed_dist21" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nLocs; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "SigmaOffDiag" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nLocs; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "SigmaOffDiagTemp" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= nKnots; ++sym1__) {
        {
          for (int sym2__ = 1; sym2__ <= nLocs; ++sym2__) {
            {
              param_names__.emplace_back(std::string() + "invSigmaKnots" + '.' + std::to_string(sym2__) + '.' + std::to_string(sym1__));
            }}
        }}
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "y_hat" + '.' + std::to_string(sym1__));
        }}
      for (int sym1__ = 1; sym1__ <= gamma_params; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "gammaA" + '.' + std::to_string(sym1__));
        }}
      param_names__.emplace_back(std::string() + "gp_sigma_sq");
    }
    
    if (emit_generated_quantities__) {
      for (int sym1__ = 1; sym1__ <= N; ++sym1__) {
        {
          param_names__.emplace_back(std::string() + "log_lik" + '.' + std::to_string(sym1__));
        }}
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"gp_theta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"gp_sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"df\",\"type\":{\"name\":\"array\",\"length\":" << est_df << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"array\",\"length\":" << norm_params << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"CV\",\"type\":{\"name\":\"array\",\"length\":" << gamma_params << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"nb2_phi\",\"type\":{\"name\":\"array\",\"length\":" << nb2_params << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"yearEffects\",\"type\":{\"name\":\"array\",\"length\":" << n_year_effects << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"year_sigma\",\"type\":{\"name\":\"array\",\"length\":" << est_temporalRE << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"spatialEffectsKnots\",\"type\":{\"name\":\"array\",\"length\":" << nT << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nKnots << "}},\"block\":\"parameters\"},{\"name\":\"B\",\"type\":{\"name\":\"vector\",\"length\":" << nCov << "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"array\",\"length\":" << est_phi << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"W\",\"type\":{\"name\":\"array\",\"length\":" << nW << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"muZeros\",\"type\":{\"name\":\"vector\",\"length\":" << nKnots << "},\"block\":\"transformed_parameters\"},{\"name\":\"spatialEffects\",\"type\":{\"name\":\"array\",\"length\":" << nT << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nLocs << "}},\"block\":\"transformed_parameters\"},{\"name\":\"SigmaKnots\",\"type\":{\"name\":\"matrix\",\"rows\":" << nKnots << ",\"cols\":" << nKnots << "},\"block\":\"transformed_parameters\"},{\"name\":\"transformed_dist\",\"type\":{\"name\":\"matrix\",\"rows\":" << nKnots << ",\"cols\":" << nKnots << "},\"block\":\"transformed_parameters\"},{\"name\":\"transformed_dist21\",\"type\":{\"name\":\"matrix\",\"rows\":" << nLocs << ",\"cols\":" << nKnots << "},\"block\":\"transformed_parameters\"},{\"name\":\"SigmaOffDiag\",\"type\":{\"name\":\"matrix\",\"rows\":" << nLocs << ",\"cols\":" << nKnots << "},\"block\":\"transformed_parameters\"},{\"name\":\"SigmaOffDiagTemp\",\"type\":{\"name\":\"matrix\",\"rows\":" << nLocs << ",\"cols\":" << nKnots << "},\"block\":\"transformed_parameters\"},{\"name\":\"invSigmaKnots\",\"type\":{\"name\":\"matrix\",\"rows\":" << nLocs << ",\"cols\":" << nKnots << "},\"block\":\"transformed_parameters\"},{\"name\":\"y_hat\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"gammaA\",\"type\":{\"name\":\"array\",\"length\":" << gamma_params << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"gp_sigma_sq\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"gp_theta\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"gp_sigma\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"df\",\"type\":{\"name\":\"array\",\"length\":" << est_df << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"sigma\",\"type\":{\"name\":\"array\",\"length\":" << norm_params << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"CV\",\"type\":{\"name\":\"array\",\"length\":" << gamma_params << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"nb2_phi\",\"type\":{\"name\":\"array\",\"length\":" << nb2_params << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"yearEffects\",\"type\":{\"name\":\"array\",\"length\":" << n_year_effects << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"year_sigma\",\"type\":{\"name\":\"array\",\"length\":" << est_temporalRE << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"spatialEffectsKnots\",\"type\":{\"name\":\"array\",\"length\":" << nT << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nKnots << "}},\"block\":\"parameters\"},{\"name\":\"B\",\"type\":{\"name\":\"vector\",\"length\":" << nCov << "},\"block\":\"parameters\"},{\"name\":\"phi\",\"type\":{\"name\":\"array\",\"length\":" << est_phi << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"W\",\"type\":{\"name\":\"array\",\"length\":" << nW << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"parameters\"},{\"name\":\"muZeros\",\"type\":{\"name\":\"vector\",\"length\":" << nKnots << "},\"block\":\"transformed_parameters\"},{\"name\":\"spatialEffects\",\"type\":{\"name\":\"array\",\"length\":" << nT << ",\"element_type\":{\"name\":\"vector\",\"length\":" << nLocs << "}},\"block\":\"transformed_parameters\"},{\"name\":\"SigmaKnots\",\"type\":{\"name\":\"matrix\",\"rows\":" << nKnots << ",\"cols\":" << nKnots << "},\"block\":\"transformed_parameters\"},{\"name\":\"transformed_dist\",\"type\":{\"name\":\"matrix\",\"rows\":" << nKnots << ",\"cols\":" << nKnots << "},\"block\":\"transformed_parameters\"},{\"name\":\"transformed_dist21\",\"type\":{\"name\":\"matrix\",\"rows\":" << nLocs << ",\"cols\":" << nKnots << "},\"block\":\"transformed_parameters\"},{\"name\":\"SigmaOffDiag\",\"type\":{\"name\":\"matrix\",\"rows\":" << nLocs << ",\"cols\":" << nKnots << "},\"block\":\"transformed_parameters\"},{\"name\":\"SigmaOffDiagTemp\",\"type\":{\"name\":\"matrix\",\"rows\":" << nLocs << ",\"cols\":" << nKnots << "},\"block\":\"transformed_parameters\"},{\"name\":\"invSigmaKnots\",\"type\":{\"name\":\"matrix\",\"rows\":" << nLocs << ",\"cols\":" << nKnots << "},\"block\":\"transformed_parameters\"},{\"name\":\"y_hat\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"transformed_parameters\"},{\"name\":\"gammaA\",\"type\":{\"name\":\"array\",\"length\":" << gamma_params << ",\"element_type\":{\"name\":\"real\"}},\"block\":\"transformed_parameters\"},{\"name\":\"gp_sigma_sq\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"},{\"name\":\"log_lik\",\"type\":{\"name\":\"vector\",\"length\":" << N << "},\"block\":\"generated_quantities\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_glmmfields_namespace::model_glmmfields;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_glmmfields_namespace::profiles__;
}
#endif
#endif
