% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmnetSE.R
\name{summary.glmnetSE}
\alias{summary.glmnetSE}
\title{Summary Function for a fitted glmnetSE Objects}
\usage{
\method{summary}{glmnetSE}(object, ...)
}
\arguments{
\item{object}{A model of the class \code{glmnetSE}.}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
The output of a \code{glmnetSE} object and the performance metric if cross-fold validation is used.
}
\description{
Print the coefficients with standard errors, confidence intervals, and p-values of a \code{\link{glmnetSE}} model. The inference statistics are only available for the coefficients without shrinkage applied. They would be biased otherwise. Only if cross-fold validation is used in the \code{glmnetSE} model, the selected performance metric is displayed. If test data is supplied the performance metric on the train as test data is displayed.
}
\examples{
\donttest{
# Estimate model

glmnetSE.model <- glmnetSE(data=swiss,cf.no.shrnkg = c("Education"), ncore = 2)


# Display model output with summary

summary(glmnetSE.model)
}
}
\keyword{glmnetSE}
\keyword{output}
\keyword{results}
\keyword{summary}
