% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.glmtlp}
\alias{predict.glmtlp}
\alias{coef.glmtlp}
\title{Predict Method for a "glmtlp" Object}
\usage{
\method{predict}{glmtlp}(
  object,
  X,
  type = c("link", "response", "class", "coefficients", "numnz", "varnz"),
  lambda = NULL,
  kappa = NULL,
  which = 1:(ifelse(object$penalty == "l0", length(object$kappa), length(object$lambda))),
  ...
)

\method{coef}{glmtlp}(
  object,
  lambda = NULL,
  kappa = NULL,
  which = 1:(ifelse(object$penalty == "l0", length(object$kappa), length(object$lambda))),
  drop = TRUE,
  ...
)
}
\arguments{
\item{object}{Fitted \code{glmtlp} model object.}

\item{X}{Matrix of new values for \code{X} at which predictions are to be
made. Must be a matrix. This argument will not used for 
\code{type=c("coefficients","numnz", "varnz")}.}

\item{type}{Type of prediction to be made. For \code{"gaussian"} models, type 
\code{"link"} and \code{"response"} are equivalent and both give the fitted 
values. For \code{"binomial"} models, type \code{"link"} gives the linear 
predictors and type \code{"response"} gives the fitted probabilities. 
Type \code{"coefficients"} computes the coefficients at the provided values 
of \code{lambda} or \code{kappa}. Note that for \code{"binomial"} 
models, results are returned only for the class corresponding to the second 
level of the factor response. Type \code{"class"} applies only to 
\code{"binomial"} models, and gives the class label corresponding to the 
maximum probability. Type \code{"numnz"} gives the total number of non-zero 
coefficients for each value of \code{lambda} or \code{kappa}. Type 
\code{"varnz"} gives a list of indices of the nonzero coefficients for 
each value of \code{lambda} or \code{kappa}.}

\item{lambda}{Value of the penalty parameter \code{lambda} at which predictions
are to be made Default is NULL.}

\item{kappa}{Value of the penalty parameter \code{kappa} at which predictions 
are to be made. Default is NULL.}

\item{which}{Index of the penalty parameter \code{lambda} or \code{kappa} 
sequence at which predictions are to be made. Default are the indices for the 
entire penalty parameter sequence.}

\item{\dots}{Additional arguments.}

\item{drop}{Whether or not keep the dimension that is of length 1.}
}
\value{
The object returned depends on \code{type}.
}
\description{
Predicts fitted values, logits, coefficients and more from a fitted 
  \code{glmtlp} object.
}
\details{
\code{coef(...)} is equivalent to \code{predict(type="coefficients",...)}
}
\examples{

# Gaussian
X <- matrix(rnorm(100 * 20), 100, 20)
y <- rnorm(100)
fit <- glmtlp(X, y, family = "gaussian", penalty = "l1")
predict(fit, X = X[1:5, ])
coef(fit)
predict(fit, X = X[1:5, ], lambda = 0.1)

# Binomial
X <- matrix(rnorm(100 * 20), 100, 20)
y <- sample(c(0,1), 100, replace = TRUE)
fit <- glmtlp(X, y, family = "binomial", penalty = "l1")
coef(fit)
predict(fit, X = X[1:5, ], type = "response")
predict(fit, X = X[1:5, ], type = "response", lambda = 0.01)
predict(fit, X = X[1:5, ], type = "class", lambda = 0.01)
predict(fit, X = X[1:5, ], type = "numnz", lambda = 0.01)

}
\references{
Shen, X., Pan, W., & Zhu, Y. (2012). 
  \emph{Likelihood-based selection and sharp parameter estimation. 
  Journal of the American Statistical Association, 107(497), 223-232.}
  \cr Shen, X., Pan, W., Zhu, Y., & Zhou, H. (2013). 
  \emph{On constrained and regularized high-dimensional regression. 
  Annals of the Institute of Statistical Mathematics, 65(5), 807-832.}
  \cr Li, C., Shen, X., & Pan, W. (2021). 
  \emph{Inference for a Large Directed Graphical Model with Interventions. 
  arXiv preprint arXiv:2110.03805.}
  \cr Yang, Y., & Zou, H. (2014). 
  \emph{A coordinate majorization descent algorithm for l1 penalized learning. 
  Journal of Statistical Computation and Simulation, 84(1), 84-95.}
  \cr Two R package Github: \emph{ncvreg} and \emph{glmnet}.
}
\seealso{
\code{print}, \code{predict}, \code{coef} and \code{plot} methods,
and the \code{cv.glmtlp} function.
}
\author{
Chunlin Li, Yu Yang, Chong Wu 
  \cr Maintainer: Yu Yang \email{yang6367@umn.edu}
}
\keyword{models}
\keyword{regression}
