% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{adjR2.gnm}
\alias{adjR2.gnm}
\title{Adjusted R-squared in Generalized Nonlinear Models}
\usage{
\method{adjR2}{gnm}(..., digits = max(3, getOption("digits") - 2), verbose = TRUE)
}
\arguments{
\item{...}{one or several objects of the class \emph{gnm}, which are obtained from the fit of generalized nonlinear models.}

\item{digits}{an (optional) integer value indicating the number of decimal places to be used. As default, \code{digits} is set to \code{max(3, getOption("digits") - 2)}.}

\item{verbose}{an (optional) logical indicating if should the report of results be printed. As default, \code{verbose} is set to TRUE.}
}
\value{
a matrix with the following columns
\tabular{ll}{
\code{Deviance} \tab value of the residual deviance,\cr
\tab \cr
\code{R-squared} \tab value of the deviance-based R-squared,\cr
\tab \cr
\code{df}       \tab number of parameters in the "linear" predictor,\cr
\tab \cr
\code{adj.R-squared} \tab value of the adjusted deviance-based R-squared,\cr
}
}
\description{
Computes the adjusted deviance-based R-squared in generalized nonlinear models.
}
\details{
The deviance-based R-squared is computed as \eqn{R^2=1 - Deviance/Null.Deviance}. Then,
the adjusted deviance-based R-squared is computed as
\eqn{1 - \frac{n-1}{n-p}(1-R^2)}, where \eqn{p} is the
number of parameters in the "linear" predictor and \eqn{n} is the sample size.
}
\examples{
###### Example 1: The effects of fertilizers on coastal Bermuda grass
data(Grass)
fit1 <- gnm(Yield ~ b0 + b1/(Nitrogen + a1) + b2/(Phosphorus + a2) + b3/(Potassium + a3),
            family=gaussian(inverse), start=c(b0=0.1,b1=13,b2=1,b3=1,a1=45,a2=15,a3=30), data=Grass)
fit2 <- update(fit1, family=Gamma(inverse))
adjR2(fit1,fit2)

###### Example 2: Developmental rate of Drosophila melanogaster
data(Drosophila)
fit1 <- gnm(Duration ~ b0 + b1*Temp + b2/(Temp-a), family=Gamma(log),
            start=c(b0=3,b1=-0.25,b2=-210,a=55), weights=Size, data=Drosophila)
fit2 <- update(fit1, family=inverse.gaussian(log))
adjR2(fit1,fit2)

###### Example 3: Radioimmunological Assay of Cortisol
data(Cortisol)
fit1 <- gnm(Y ~ b0 + (b1-b0)/(1 + exp(b2+ b3*lDose))^b4, family=Gamma(identity),
            start=c(b0=130,b1=2800,b2=3,b3=3,b4=0.5), data=Cortisol)
fit2 <- update(fit1, family=gaussian(identity))
adjR2(fit1,fit2)

###### Example 4: Age and Eye Lens Weight of Rabbits in Australia
data(rabbits)
fit1 <- gnm(wlens ~ b1 - b2/(age + b3), family=Gamma(log),
            start=c(b1=5.5,b2=130,b3=35), data=rabbits)
fit2 <- update(fit1, family=gaussian(log))
adjR2(fit1,fit2)

}
