% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-construct-instrument-.R
\name{Instrument}
\alias{Instrument}
\title{Create \code{Instrument} Object}
\usage{
Instrument(instrument, to = NULL, volume = NULL, pan = NULL)
}
\arguments{
\item{instrument}{A single integer between \code{1} and \code{128}, which indicates
the \href{https://en.wikipedia.org/wiki/General_MIDI#Program_change_events}{program number }
of the instrument. See the \emph{Details} section for all instruments.}

\item{to}{Optional. A single character or a single positive integer,
which indicates the musical line where to add the instrument.}

\item{volume}{Optional. A single integer between \code{0} and \code{100}, which
represents the volume of the instrument. The default value is \code{80}.
Please note that \code{volume} and \code{pan} only work in MuseScore 3.}

\item{pan}{Optional. A single integer between \code{-90} and \code{90}, which
represents the panning of the instrument. The default value is \code{0}.}
}
\value{
A list of class \code{Instrument}.
}
\description{
Create an \code{Instrument} object to represent an instrument.
}
\details{
Supported instruments:
\enumerate{
\item Acoustic Grand Piano
\item Bright Acoustic Piano
\item Electric Grand Piano
\item Honky-Tonk Piano
\item Electric Piano 1
\item Electric Piano 2
\item Harpsichord
\item Clavinet
\item Celesta
\item Glockenspiel
\item Music Box
\item Vibraphone
\item Marimba
\item Xylophone
\item Tubular Bells
\item Dulcimer
\item Drawbar Organ
\item Percussive Organ
\item Rock Organ
\item Church Organ
\item Reed Organ
\item Accordion
\item Harmonica
\item Tango Accordion
\item Acoustic Guitar (Nylon)
\item Acoustic Guitar (Steel)
\item Electric Guitar (Jazz)
\item Electric Guitar (Clean)
\item Electric Guitar (Muted)
\item Overdriven Guitar
\item Distortion Guitar
\item Guitar Harmonics
\item Acoustic Bass
\item Electric Bass (Finger)
\item Electric Bass (Pick)
\item Fretless Bass
\item Slap Bass 1
\item Slap Bass 2
\item Synth Bass 1
\item Synth Bass 2
\item Violin
\item Viola
\item Cello
\item Contrabass
\item Tremolo Strings
\item Pizzicato Strings
\item Orchestral Harp
\item Timpani
\item String Ensemble 1
\item String Ensemble 2
\item Synth Strings 1
\item Synth Strings 2
\item Choir Aahs
\item Voice Oohs
\item Synth Voice
\item Orchestra Hit
\item Trumpet
\item Trombone
\item Tuba
\item Muted Trumpet
\item French Horn
\item Brass Section
\item Synth Brass 1
\item Synth Brass 2
\item Soprano Sax
\item Alto Sax
\item Tenor Sax
\item Baritone Sax
\item Oboe
\item English Horn
\item Bassoon
\item Clarinet
\item Piccolo
\item Flute
\item Recorder
\item Pan Flute
\item Blown Bottle
\item Shakuhachi
\item Whistle
\item Ocarina
\item Lead 1 (Square)
\item Lead 2 (Sawtooth)
\item Lead 3 (Calliope)
\item Lead 4 (Chiff)
\item Lead 5 (Charang)
\item Lead 6 (Voice)
\item Lead 7 (Fifths)
\item Lead 8 (Bass + Lead)
\item Pad 1 (New Age)
\item Pad 2 (Warm)
\item Pad 3 (Polysynth)
\item Pad 4 (Choir)
\item Pad 5 (Bowed)
\item Pad 6 (Metallic)
\item Pad 7 (Halo)
\item Pad 8 (Sweep)
\item FX 1 (Rain)
\item FX 2 (Soundtrack)
\item FX 3 (Crystal)
\item FX 4 (Atmosphere)
\item FX 5 (Brightness)
\item FX 6 (Goblins)
\item FX 7 (Echoes)
\item FX 8 (Sci-Fi)
\item Sitar
\item Banjo
\item Shamisen
\item Koto
\item Kalimba
\item Bag Pipe
\item Fiddle
\item Shanai
\item Tinkle Bell
\item Agogo
\item Steel Drums
\item Woodblock
\item Taiko Drum
\item Melodic Tom
\item Synth Drum
\item Reverse Cymbal
\item Guitar Fret Noise
\item Breath Noise
\item Seashore
\item Bird Tweet
\item Telephone Ring
\item Helicopter
\item Applause
\item Gunshot
}
}
\examples{
# Create a flute
flute <- Instrument(74, pan = -90)
flute

# Add it to a `Music`
music <- Music() + Meter(4, 4) + Line(c("C5", "D5", "E5", "F5")) + flute
music

# Generate the music score
if (interactive()) {
  show(music)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding an instrument to a \code{Music} object.
}
