% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-construct-key.R
\name{Key}
\alias{Key}
\title{Create \code{Key} Object}
\usage{
Key(key, bar = NULL, to = NULL, scope = NULL)
}
\arguments{
\item{key}{A single integer between -7 and 7, which indicates
the number of flat or sharp symbols in the key signature.}

\item{bar}{Optional. A positive integer, which indicates the number of
the measure where to add the key signature. By default, the
key signature will be added at the first measure.}

\item{to}{Optional. A single character or a single positive integer,
which indicates the musical line where to add the key signature.
By default, the key signature will be added to the whole music
rather than some specific musical line.}

\item{scope}{Optional. A single character of \code{"part"} or \code{"staff"},
which indicates whether to add the key signature to a whole part or
only some staff of the part. Only when \code{to} is specified, can this
argument be specified. The default value is \code{"part"}.}
}
\value{
A list of class \code{Key}.
}
\description{
Create a \code{Key} object to represent a key signature.
}
\examples{
# Create a G major
g <- Key(1, to = 1)
g

# Add it only to some part of a `Music`
music <-
  Music() +
  Meter(4, 4) +
  Line(c("C4", "D4")) +
  Line("G3") +
  g

music

# Generate the music score
if (interactive()) {
  show(music)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding a key signature to a \code{Music} object.
}
