% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-construct-lyric.R
\name{Lyric}
\alias{Lyric}
\title{Create \code{Lyric} Object}
\usage{
Lyric(text, i, to = NULL, verse = NULL)
}
\arguments{
\item{text}{A single character, which usually represents a word or
syllable of the lyrics. See the \emph{Details} section for more
complex usage.}

\item{i}{A single positive integer, which represents the position
of the \code{Lyric} in a musical line.}

\item{to}{Optional. A single character or a single positive integer,
which indicates the musical line where to add the \code{Lyric}.}

\item{verse}{Optional. A positive integer which indicates the verse
where to add the \code{Lyric}. The default value is 1. See
\href{https://musescore.org/en/handbook/4/lyrics#overview}{the MuseScore handbook }.}
}
\value{
A list of class \code{Lyric}.
}
\description{
Create a \code{Lyric} object to represent a unit of lyrics.
}
\details{
You can use \code{"-"} and \code{"_"} in argument \code{text} to create the following
structures:
\itemize{
\item \href{https://musescore.org/en/handbook/4/lyrics#enter-syllables}{Syllable}:
for example, with \code{Lyric("mo-", 1)} and \code{Lyric("-ther", 3)}, the two
syllables of \emph{mother} are added to the first and third notes, with
a hyphen placed on the second note.
\item \href{https://musescore.org/en/handbook/4/lyrics#enter-melisma}{Melisma}:
for example, with \code{Lyric("love_", 1)} and \code{Lyric("_", 3)}, the word
\emph{love} is added to the first note, followed by an underscore line
which extends over the second and third notes.
\item \href{https://musescore.org/en/handbook/4/lyrics#elision-slur}{Elision}:
for example, with \code{Lyric("my_love", 1)}, words \emph{my} and \emph{love} are both
added to the first note, connected by an elision slur.
}

Use \code{"\\\\-"} and \code{"\\\\_"} if you want to add hyphens and
underscores literally.
}
\examples{
# Create two syllables
syllable_1 <- Lyric("He-", 1)
syllable_2 <- Lyric("-llo", 3)
syllable_1
syllable_2

# Add them to a `Music`
music <-
  Music() +
  Meter(4, 4) +
  Line(c("C4", "D4", "E4")) +
  syllable_1 +
  syllable_2

music

# Generate the music score
if (interactive()) {
  show(music)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding a \code{Lyric} to a \code{Music} object.
}
