% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-construct-trill.R
\name{Trill}
\alias{Trill}
\title{Create \code{Trill} Object}
\usage{
Trill(i, j = NULL, to = NULL)
}
\arguments{
\item{i}{A single positive integer, which represents the position
of the trill in a musical line.}

\item{j}{Optional. A single positive integer, which indicates the end
position of the trill line in a musical line. If not provided, the trill
will appear as a \emph{tr} symbol above only the trilled note. Otherwise, it
will appear as a \emph{tr~~~} symbol above the notes between the start and
end positions.}

\item{to}{Optional. A single character or a single positive integer,
which indicates the musical line where to add the trill.}
}
\value{
A list of class \code{Trill}.
}
\description{
Create a \code{Trill} object to represent a trill ornament.
}
\examples{
# Create a trill
trill <- Trill(1, 3)
trill

# Add it to a `Music`
music <- Music() + Meter(4, 4) + Line(c("C4", "D4", "E4", "F4")) + trill
music

# Generate the music score
if (interactive()) {
  show(music)
}
}
\seealso{
\code{\link[=+.Music]{+.Music()}} for adding a trill to a \code{Music} object.
}
