% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.R
\name{summary}
\alias{summary}
\alias{summary.gmm}
\alias{summary.gmbn}
\alias{summary.gmdbn}
\title{Summarize a Gaussian mixture model or graphical model}
\usage{
\method{summary}{gmm}(object, ...)

\method{summary}{gmbn}(object, ...)

\method{summary}{gmdbn}(object, ...)
}
\arguments{
\item{object}{An object of class \code{gmm}, \code{gmbn} or \code{gmdbn}.}

\item{\dots}{Unused arguments from the generic function.}
}
\value{
If \code{object} is a \code{gmm} object, an integer vector containing
the number of variables, mixture components and free parameters.

If \code{object} is a \code{gmbn} or \code{gmdbn} object, a list with
elements:
\item{global}{An integer vector containing the global number of nodes, arcs,
mixture components and free parameters (for a \code{gmdbn} object, also the
number of \code{gmbn} elements).}
\item{local}{For a \code{gmbn} object, an integer matrix containing the local
numbers of arcs, mixture components and free parameters. For a \code{gmdbn}
object, a list of integer matrices containing these statistics for each
\code{gmbn} elements.}
}
\description{
This function summarizes a Gaussian mixture model or graphical model.
}
\examples{
data(gmm_body)
summ_1 <- summary(gmm_body)

data(gmbn_body)
summ_2 <- summary(gmbn_body)

data(gmdbn_air)
summ_3 <- summary(gmdbn_air)

}
