% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fulldataOutput.R
\name{fulldataOutput}
\alias{fulldataOutput}
\title{fulldataOutput}
\usage{
fulldataOutput(
  declarations_file = "declarations.gms",
  definitions_file = "postsolve.gms",
  warn = TRUE,
  types = c("level", "marginal"),
  ignore = "_dummy$",
  loopset = "t"
)
}
\arguments{
\item{declarations_file}{A GAMS file containing declarations. The function
will read declarations from here and add own declarations in an R
environment as used by \code{\link{replace_in_file}} (used subject = OUTPUT
DECLARATIONS)}

\item{definitions_file}{A GAMS file which is executed after the solve
statement but within the time step loop. Also here code will be added using
\code{\link{replace_in_file}} with subject OUTPUT DEFINITIONS}

\item{warn}{Decides whether a warning should be thrown out, if the
declarations file does not exist.}

\item{types}{Types of outputs that should be written to gdx file. Available
types are level, marginal, upper and lower.}

\item{ignore}{regular expression pattern for variables/equations which
should be ignored by fulldataOutput}

\item{loopset}{Set over which loop runs}
}
\description{
Creates GAMS code which stores automatically the levels, bounds and
marginals of all equations and variables in time depending parameters.
}
\seealso{
\code{\link{readDeclarations}},\code{\link{replace_in_file}}
}
\author{
Jan Philipp Dietrich, Felicitas Beier
}
