% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/setScenario.R
\name{setScenario}
\alias{setScenario}
\title{setScenario}
\usage{
setScenario(cfg, scenario, scenario_config = "config/scenario_config.csv")
}
\arguments{
\item{cfg}{Input config which should be adapted to the given scenario}

\item{scenario}{name of scenario (e.g. "SSP2"). Can also be a vector of
scenarios. In this case scenario settings are applied in the given order}

\item{scenario_config}{The path where the scenario config table is stored.}
}
\value{
The updated config as a config list ready for further usage.
}
\description{
setScenario is adapting a given config to a predefined scenario, meaning
that all settings which are fixed for the given scenario are written to the
config. Settings not defined by the scenario remain unchanged.
}
\note{
The scenario config table is a table which contains as columns the
different scenarios and as rows the different settings. Empty entries for a
given scenario-setting combination indicate that this setting is not defined
by the scenario and should not be changed by set Scenario!
}
\seealso{
\code{\link{check_config}},\code{\link{getModules}}
}
\author{
Jan Philipp Dietrich, Anastasis Giannousakis
}
