% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validateMatrices.R
\name{validateMatrices}
\alias{validateMatrices}
\title{Validates the input of a goal programming problem}
\usage{
validateMatrices(
  A,
  b,
  m,
  w = NULL,
  p = NULL,
  setDefaults = FALSE,
  silent = FALSE
)
}
\arguments{
\item{A}{Numeric matrix with the coefficients of the variables. One row
per equation, one column per variable.}

\item{b}{Numeric vector with the values on the right hand side of the
goals.}

\item{m}{Character vector with the relationship between the left and
right-hand side of the goals. It can be any of
\code{=, ==, <=, >=}.}

\item{w}{Numeric matrix with the weights associated to the deviations
from each goal. It should have as many rows as goals,
and two columns: the first column corresponding to the weight of
the positive deviation (excess), and the second column
corresponding to the weight of the negative deviation (lack).}

\item{p}{Numeric matrix indicating the priority of each deviation under
a lexicographic approach. Lower numbers represent higher
priority (e.g. from lower to higher priority: 1, 2, 3, ...).
It must have as many rows as goals, and two columns.}

\item{setDefaults}{Scalar logical. If TRUE, A, b, m, w, and p are filled
in with default values as required.}

\item{silent}{Logical. TRUE to prevent the function writing anything
to the console (or the default output). Default is FALSE.}
}
\description{
Validates the input of a goal programming problem
}
