% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zones.R
\name{gtm_zones_create}
\alias{gtm_zones_create}
\title{Create a new zone}
\usage{
gtm_zones_create(account_id, container_id, workspace_id, zone_object)
}
\arguments{
\item{account_id}{Account Id}

\item{container_id}{Container Id}

\item{workspace_id}{Workspace Id}

\item{zone_object}{Zone Object}
}
\description{
This takes a zone resource and creates a new zone in GTM.
}
\examples{
\dontrun{
accountId <- 1234567
containerId <- 7654321
workspaceId <- 10


 
zone <- list(
    accountId=accountId,
    containerId=containerId,
    workspaceId=workspaceId,
    name="Marketing Zone",
    childContainer=list(
      list(
        publicId="GTM-ABCDEF",
        nickname="My Marketing Container"
     )
   )
)
 
new_zone <- gtm_zones_create(accountId, containerId, workspaceId, zone)
 
}
}
\seealso{
\url{https://developers.google.com/tag-platform/tag-manager/api/v2/reference/accounts/containers/workspaces/zones/create}

Other zone functions: 
\code{\link{gtm_zones_delete}()},
\code{\link{gtm_zones_get}()},
\code{\link{gtm_zones_list}()},
\code{\link{gtm_zones_revert}()},
\code{\link{gtm_zones_update}()}
}
\concept{zone functions}
