% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flatten.R
\name{flatten_sentiment}
\alias{flatten_sentiment}
\title{Flatten sentiment}
\usage{
flatten_sentiment(sentiment_list)
}
\arguments{
\item{sentiment_list}{The \code{sentiment} component of the API response.}
}
\value{
A flattened data frame.
}
\description{
Convert the JSON/list \code{sentiment} response into a flattened data frame.
}
\examples{
\dontrun{
sample_post <- gcnlp_post(text_body = "Google, headquartered in Mountain View, unveiled
                                       the new Android phone at the Consumer Electronic Show.
                                       Sundar Pichai said in his keynote that users love
                                       their new Android phones.",
                          extract_syntax = TRUE,
                          extract_entities = TRUE,
                          extract_document_sentiment = TRUE)

flatten_sentiment(sentiment_list = sample_post$content$sentiment)
}

}
