% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/1-grafos-basic.R
\encoding{UTF-8}
\name{find_euler}
\alias{find_euler}
\title{Constructing an Eulerian Cycle}
\usage{
find_euler(G, v)
}
\arguments{
\item{G}{Eulerian and connected graph}

\item{v}{Any vertex as starting point of the cycle}
}
\value{
A two-element list: the $walk component is a
\eqn{q\times2} matrix edgelist, and the $graph component is
the input graph with no edges; it is used in intermediate
steps, when the function calls itself.
}
\description{
It finds an \strong{Eulerian cycle} using a
\eqn{O(q)} algorithm where \eqn{q} is the number of edges of
the graph.
}
\details{
Recursive algorithm for undirected graphs.
The input graph should be Eulerian and connected.
}
\section{Disclaimer}{

This function is part of the subject "Graphs and Network
Optimization".  It is designed for teaching purposes only, and
not for production.
\itemize{
\item It is introduced in the "Connectivity" section.
\item It is used as a subroutine in the "TSP" section.
}
}

\examples{
library(igraph)
find_euler(make_full_graph(5), 1)$walk   # Walk of length 10

}
\references{
\emph{Korte, Vygen: Combinatorial Optimization (Springer)} sec 2.4.
}
\seealso{
\link{build_tour_2tree} double-tree algorithm.
}
\author{
Cesar Asensio (2021)
}
