% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11-grafos-NPdif.R
\encoding{UTF-8}
\name{make_cube}
\alias{make_cube}
\title{Multidimensional cube graph}
\usage{
make_cube(mu)
}
\arguments{
\item{mu}{Dimension of the cube, a nonnegative integer.}
}
\value{
The \eqn{\mu}-dimensional cube graph in igraph format.
}
\description{
Multidimensional cube graph: 4-cycle (\eqn{\mu=2}), ordinary cube
(\eqn{\mu=3}), tesseract (\eqn{\mu=4}), etc.
}
\details{
This is a recursive function: It forms the \eqn{\mu}-cube by
joining two (\eqn{\mu-1})-cubes vertex by vertex, starting from
the 1-cube, which is \eqn{K_1}, a single vertex with no edges.
The \eqn{\mu}-cube has \eqn{2^\mu} vertices and
\eqn{\mu\times2^{\mu-1}} edges, so it is exponentially big in
\eqn{\mu}, please consider this when creating a \eqn{\mu}-cube
with moderate \eqn{\mu} (and \strong{don't} create any cube
with large \eqn{\mu}).
}
\examples{
library(igraph)
q3 <- make_cube(3)
cu <- make_graph("Cubical")
isomorphic(cu, q3)   # TRUE

}
\author{
Cesar Asensio
}
