% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/published.R
\name{gpo_published}
\alias{gpo_published}
\title{Retrieve documents based on official publication date.}
\usage{
gpo_published(
  start_date,
  end_date = NULL,
  page_size = 10,
  collection,
  congress = NULL,
  doc_class = NULL,
  bill_version = NULL,
  modified_since = NULL,
  court_code = NULL,
  court_type = NULL,
  state = NULL,
  topic = NULL,
  nature_suit_code = NULL,
  nature_suit = NULL,
  offset_mark = "*",
  is_glp = NULL
)
}
\arguments{
\item{start_date}{ISO8601 date and time formatted string (yyyy-MM-dd'T'HH:mm:ss'Z')
Example: 2018-01-28T20:18:10Z}

\item{end_date}{ISO8601 date and time formatted string (yyyy-MM-dd'T'HH:mm:ss'Z')
Example: 2018-01-28T20:18:10Z}

\item{page_size}{The number of records to return for a given request.}

\item{collection}{Filter by GPO collection.}

\item{congress}{Filter by Congress, e.g., 116, 117}

\item{doc_class}{Filter by collection-specific categories, which vary among collections.}

\item{bill_version}{Specific to the \code{BILLS} collection. Filter by bill text version code.}

\item{modified_since}{Request only packages modified since a given date/time.
ISO8601 date and time formatted string (yyyy-MM-dd'T'HH:mm:ss'Z')
Example: 2018-01-28T20:18:10Z}

\item{court_code}{\code{USCOURTS}collection specific.}

\item{court_type}{\code{USCOURTS} collection specific.}

\item{state}{Collection specific.}

\item{topic}{Collection specific.}

\item{nature_suit_code}{Collection specific.}

\item{nature_suit}{Collection specific.}

\item{offset_mark}{Indicates starting record for a given request.}

\item{is_glp}{Collection specific.}
}
\value{
A tibble
}
\description{
The following params correspond to those listed in the
\href{https://www.govinfo.gov/}{GovInfo} API documentation, but the \code{offset} param is not
supported. GovInfo documentation indicates that it was to be deprecated in December, 2022, and
though it is still available through the API, the \code{offsetMark} parameter is supported instead.
Parameter descriptions are adapted from \href{https://www.govinfo.gov/}{GovInfo} API documentation.
}
\examples{
\dontshow{if (govinfoR::has_govinfo_key()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

gpo_published(
  start_date = "2024-01-01",
  end_date = "2024-01-03",
  collection = c("BILLS")
)
\dontshow{\}) # examplesIf}
}
