% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hdnaO.R
\name{hdnaO}
\alias{hdnaO}
\title{Predicting intramolecular triplexes (H-DNA) including overlaps}
\usage{
hdnaO(x, xformat = "default")
}
\arguments{
\item{x}{DNA sequence(s) in raw format or a fasta file or a GenBank accession number(s); from which H-DNA (including overlaps) will be predicted.
If the fasta file name does not contain an absolute path, the file name is relative to the current working directory.}

\item{xformat}{a character string specifying the format of x : default (raw), fasta, GenBank (GenBank accession number(s)).}
}
\value{
A dataframe of H-DNA' position, sequence and length. If more than one DNA sequence is provided as argument, an input ID is returned for motif(s) predicted from each input sequence.
}
\description{
This function predicts H-DNA
in 'x' DNA sequence like the hdna function, but includes overlaps.
DNA sequence can be provided in raw or fasta format or as GenBank accession number(s).
Internet is needed to connect to GenBank database, if accession number(s) is given as argument.
}
\details{
This function predicts H-DNA in DNA sequences, including overlaps and provide the position, sequence and length of the predicted motif(s), if any.
}
\examples{
## Predicting H-DNA (including overlaps) from raw DNA sequences
E1 <- c("TCTTCCCCCCTTTTTYYYYYGCTYYYYYTTTTTCCCCCCGAAT", "taggtgctgggaggtagagacaggatatcct")
hdnaO(E1)

## Predicting H-DNA (including overlaps) from DNA sequences in fasta file
## Not run: hdnaO(x="Example.fasta", xformat = "fasta")

## Predicting H-DNA (including overlaps) from DNA sequences,
## using GenBank accession numbers.
## Internet connectivity is needed for this to work.
## Not run: hdnaO(c("BH114913", "AY611035"), xformat = "GenBank")
}
\references{
Paper on gquad and the web application (Non-B DNA Predictor) is under review, see draft in vignettes
}
\seealso{
hdna
}
\author{
Hannah O. Ajoge
}
