% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grPipe.create.R
\name{grPipe.create}
\alias{grPipe.create}
\title{Create New Graphviz Data.Frame (grPipe Nodes)}
\usage{
grPipe.create(nrow = 0, ncol = 0)
}
\arguments{
\item{nrow}{integer}

\item{ncol}{integer}
}
\value{
Returns a data.frame with 3 columns (id, id_next and text) where:
\itemize{
    \item if nrow==0 or ncol==0, then return an empty data.frame;
    \item if nrow>0 and ncol>0, then return a data.frame with one row:
    \itemize{
        \item id = paste0(LETTERS[nrow], ncol)
        \item id_next = NA
        \item text = NA
    }
}
}
\description{
if nrow or ncol parameters are equal zero, then the output will be an empty data.frame.
}
\examples{
nodes = grPipe.create()
nodes = grPipe.create(nrow = 2, ncol = 5)

}
\author{
Daniel Gaspar Gonçalves
}
